/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;

public class DBIDRangeRouter
implements DocRouter {
    private long startRange;
    private AtomicLong expandableRange;
    private AtomicBoolean expanded = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public DBIDRangeRouter(long startRange, long endRange) {
        this.startRange = startRange;
        this.expandableRange = new AtomicLong(endRange);
    }

    public void setEndRange(long endRange) {
        this.expandableRange.set(endRange);
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public void setInitialized(boolean initialized) {
        this.initialized.set(initialized);
    }

    public boolean getInitialized() {
        return this.initialized.get();
    }

    public long getEndRange() {
        return this.expandableRange.longValue();
    }

    public long getStartRange() {
        return this.startRange;
    }

    public boolean getExpanded() {
        return this.expanded.get();
    }

    @Override
    public Boolean routeAcl(int shardCount, int shardInstance, Acl acl) {
        return true;
    }

    @Override
    public Boolean routeNode(int shardCount, int shardInstance, Node node) {
        long dbid = node.getId();
        return dbid >= this.startRange && dbid < this.expandableRange.longValue();
    }

    @Override
    public Map<String, String> getProperties(Optional<QName> shardProperty) {
        return Map.of("shard.range", this.startRange + "-" + String.valueOf(this.expandableRange));
    }
}

