/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Optional;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DBIDRouter;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.util.ISO8601DateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMonthRouter
implements DocRouter {
    protected static final Logger log = LoggerFactory.getLogger(DateMonthRouter.class);
    DBIDRouter dbidRouter = new DBIDRouter();
    private final int grouping;

    public DateMonthRouter(String groupparam) {
        try {
            this.grouping = Integer.parseInt(groupparam);
        }
        catch (NumberFormatException e) {
            log.error("shard.date.grouping needs to be a valid integer.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Boolean routeAcl(int numShards, int shardInstance, Acl acl) {
        return true;
    }

    @Override
    public Boolean routeNode(int numShards, int shardInstance, Node node) {
        if (numShards <= 1) {
            return true;
        }
        String ISO8601Date = node.getShardPropertyValue();
        if (ISO8601Date == null) {
            return this.dbidRouter.routeNode(numShards, shardInstance, node);
        }
        try {
            Date date = ISO8601DateFormat.parse((String)ISO8601Date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            int month = cal.get(2);
            int year = cal.get(1);
            return (year * 12 + month) / this.grouping % numShards == shardInstance;
        }
        catch (Exception exception) {
            return this.dbidRouter.routeNode(numShards, shardInstance, node);
        }
    }

    @Override
    public Map<String, String> getProperties(Optional<QName> shardProperty) {
        return shardProperty.map(QName::getPrefixString).map(prefix -> Map.of("shard.key", prefix, "shard.date.grouping", String.valueOf(this.grouping))).orElse(Collections.emptyMap());
    }
}

