/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.highlight;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlfrescoHighlighterIT
extends AbstractAlfrescoSolrIT {
    private static final Log LOGGER = LogFactory.getLog(AlfrescoHighlighterIT.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoHighlighterIT.initAlfrescoCore("schema.xml");
        AlfrescoHighlighterIT.loadData();
    }

    protected static void loadData() throws Exception {
        String long_text = "this is some long text.  It has the word long in many places.  In fact, it has long on some different fragments.  Let us see what happens to long in this case.";
        List<Map> data = Arrays.asList(ImmutableMap.of((Object)"name", (Object)"some very long name", (Object)"description", (Object)"mydesc", (Object)"title", (Object)"title1 is very long"), ImmutableMap.of((Object)"name", (Object)long_text, (Object)"title", (Object)"title2"), ImmutableMap.of((Object)"name", (Object)"MixedCabbageString and plurals and discussion", (Object)"title", (Object)"title2"));
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(acl, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        long MAX_WAIT_TIME = 80000L;
        AlfrescoHighlighterIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        String owner = "mike";
        Transaction foldertxn = AlfrescoSolrUtils.getTransaction(0, 1);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 2);
        Node folderNode = AlfrescoSolrUtils.getNode(foldertxn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, foldertxn, acl, owner, null, false);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<NodeMetaData> metadataList = new ArrayList<NodeMetaData>();
        data.forEach(entry -> {
            Node node = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
            nodeList.add(node);
            NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(node, txn, acl, owner, AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
            Map properties = fileMetaData.getProperties();
            properties.put(ContentModel.PROP_NAME, new StringPropertyValue((String)entry.get("name")));
            HashMap<Locale, String> titleProp = new HashMap<Locale, String>();
            titleProp.put(Locale.ENGLISH, (String)entry.get("title"));
            properties.put(ContentModel.PROP_TITLE, new MLTextPropertyValue(titleProp));
            String description = (String)entry.get("description");
            if (description != null) {
                HashMap<Locale, String> descProp = new HashMap<Locale, String>();
                descProp.put(Locale.ENGLISH, description);
                properties.put(ContentModel.PROP_DESCRIPTION, new MLTextPropertyValue(descProp));
            }
            metadataList.add(fileMetaData);
        });
        AlfrescoHighlighterIT.indexTransaction(foldertxn, Collections.singletonList(folderNode), Collections.singletonList(folderMetaData));
        AlfrescoHighlighterIT.indexTransaction(txn, nodeList, metadataList);
        AlfrescoHighlighterIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 1L, MAX_WAIT_TIME);
        AlfrescoHighlighterIT.waitForDocCount((Query)new TermQuery(new Term("OWNER", owner)), 4L, MAX_WAIT_TIME);
    }

    @AfterClass
    public static void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
        SOLRAPIQueueClient.NODE_CONTENT_MAP.clear();
    }

    @Test
    public void highlightingSnippetsFragSizeTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "long", "hl.fl", "content,name,title", "hl.snippets", "4", "hl.fragsize", "40"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=2]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='some very <em>long</em> name']", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 is very <em>long</em>']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.='this is some <em>long</em> text.  It has the']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' word <em>long</em> in many places.  In fact, it has']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' <em>long</em> on some different fragments.  Let us']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' see what happens to <em>long</em> in this case.']");
    }

    @Test
    public void highlightingPhraseQueriesTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "\"some long\"", "hl.fl", "name", "hl.simple.pre", "(", "hl.simple.post", ")", "hl.snippets", String.valueOf(1), "hl.fragsize", String.valueOf(100)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "//lst[@name='highlighting']/lst/arr/str[.='this is (some) (long) text.  It has the word long in many places.  In fact, it has long on some']");
        req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "\"some long\"", "hl.fl", "name", "hl.usePhraseHighlighter", "false", "hl.simple.pre", "(", "hl.simple.post", ")", "hl.snippets", String.valueOf(1), "hl.fragsize", String.valueOf(100)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "//lst[@name='highlighting']/lst/arr/str[.='(some) very (long) name']", "//lst[@name='highlighting']/lst/arr/str[.='this is (some) (long) text.  It has the word (long) in many places.  In fact, it has (long) on (some)']");
    }

    @Test
    public void highlightingMaxAnalyzedCharsTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "long", "hl.fl", "name,title", "hl.maxAnalyzedChars", "30", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=2]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=2]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='some very {long} name']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.='this is some {long} text']");
    }

    @Test
    public void highlightingMergeContinuousFragmentsTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "'some long'", "hl.fl", "name", "hl.mergeContiguous", "true", "hl.simple.pre", "{", "hl.simple.post", "}", "hl.snippets", String.valueOf(4), "hl.fragsize", String.valueOf(40)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst/arr)=1]", "//lst[@name='highlighting']/lst/arr[@name='name']/str[.='this is {some} {long} text.  It has the word long in many places.  In fact, it has long on some different fragments.  Let us see what happens to long in this case.']");
    }

    @Test
    public void highlightingLocalConfigurationsTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "long", "hl.fl", "name,title", "f.title.hl.simple.pre", "(", "f.title.hl.simple.post", ")", "f.name.hl.simple.pre", "[", "f.name.hl.simple.post", "]", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=2]", "*[count(//lst[@name='highlighting']/lst/str[@name='DBID'])=2]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='some very [long] name']", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 is very (long)']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.='this is some [long] text.  It has the word [long] in many places.  In fact, it has [long] on some']");
    }

    @Test
    public void highlightingRequiredFieldsTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "long", "hl.fl", "name,title", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=2]", "*[count(//lst[@name='highlighting']/lst/arr[@name='title'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 is very {long}']");
        req = this.areq(AlfrescoHighlighterIT.params("q", "name:long OR title:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "title:long", "hl.fl", "name,title", "hl.requireFieldMatch", "true", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=2]", "*[count(//lst[@name='highlighting']/lst/arr[@name='title'])=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=0]", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 is very {long}']");
    }

    @Test
    public void highlightingPrePostTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:long", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.q", "long", "hl.fl", "content,name,title", "hl.simple.pre", "<al>", "hl.simple.post", "<fresco>", "hl.snippets", String.valueOf(4), "hl.fragsize", String.valueOf(40)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=2]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='some very <al>long<fresco> name']", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 is very <al>long<fresco>']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.='this is some <al>long<fresco> text.  It has the']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' word <al>long<fresco> in many places.  In fact, it has']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' <al>long<fresco> on some different fragments.  Let us']", "//lst[@name='highlighting']/lst[2]/arr[@name='name']/str[.=' see what happens to <al>long<fresco> in this case.']");
    }

    @Test
    public void highlightingCamelCaseTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:cabbage", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.fl", "name", "hl.highlightMultiTerm", "false", "hl.simple.pre", "{", "hl.simple.post", "}", "hl.snippets", String.valueOf(1), "hl.fragsize", String.valueOf(100)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='Mixed{Cabbage}String and plurals and discussion']");
    }

    @Test
    public void highlightingPluralsTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:plural", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.fl", "name", "hl.highlightMultiTerm", "false", "hl.simple.pre", "{", "hl.simple.post", "}", "hl.snippets", String.valueOf(1), "hl.fragsize", String.valueOf(100)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='MixedCabbageString and {plurals} and discussion']");
    }

    @Test
    public void highlightingStemmingTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "name:discuss", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.fl", "name", "hl.highlightMultiTerm", "false", "hl.simple.pre", "{", "hl.simple.post", "}", "hl.snippets", String.valueOf(1), "hl.fragsize", String.valueOf(100)), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='MixedCabbageString and plurals and {discussion}']");
    }

    @Test
    public void highlightingBooleanConjunctionTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "title:(is AND long)", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.fl", "title", "hl.highlightMultiTerm", "false", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='title'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='title']/str[.='title1 {is} very {long}']");
    }

    @Test
    public void highlightingBooleanConjunctionGenericTextTest() {
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(AlfrescoHighlighterIT.params("q", "(very AND name)", "qt", "/afts", "start", "0", "rows", "5", "hl", "true", "hl.fl", "name", "hl.highlightMultiTerm", "false", "hl.simple.pre", "{", "hl.simple.post", "}"), "{\"locales\":[\"en\"], \"tenants\": [ \"\" ]}");
        AlfrescoHighlighterIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='highlighting']/lst)=1]", "*[count(//lst[@name='highlighting']/lst/arr[@name='name'])=1]", "//lst[@name='highlighting']/lst[1]/arr[@name='name']/str[.='some {very} long {name}']");
    }
}

