/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.LinkedList;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.query.Solr4QueryParser;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Solr4QueryParserTest {
    private Solr4QueryParser parser;
    private static final String TEST_FIELD = "creator";
    private static final String TEST_QUERY = "user@1user1";
    private SearchParameters searchParameters = new SearchParameters();

    @Before
    public void setUp() throws Exception {
        SolrQueryRequest req = (SolrQueryRequest)Mockito.mock(SolrQueryRequest.class);
        this.parser = new Solr4QueryParser(req, Version.LATEST, "TEXT", null, FTSQueryParser.RerankPhase.SINGLE_PASS);
        this.parser.setSearchParameters(this.searchParameters);
    }

    private PackedTokenAttributeImpl getTokenAttribute(String text, int startOffset, int endOffset) {
        PackedTokenAttributeImpl token = new PackedTokenAttributeImpl();
        token.setEmpty().append(text);
        token.setOffset(startOffset, endOffset);
        return token;
    }

    @Test
    public void testGetSearchParameters() {
        Assert.assertEquals((Object)this.searchParameters, (Object)this.parser.getSearchParameters());
    }

    @Test
    public void testSQLTranslationFailure() throws ParseException {
        try {
            this.parser.getLikeQuery("example", "_%woof_\\", null);
            Assert.fail();
        }
        catch (FTSQueryException fTSQueryException) {
            // empty catch block
        }
    }

    @Test
    public void testFlatQueryShouldBeGeneratedFromSequentiallyShiftedTokens() throws Exception {
        LinkedList<PackedTokenAttributeImpl> tokenSequenceWithRepeatedGroup = new LinkedList<PackedTokenAttributeImpl>();
        tokenSequenceWithRepeatedGroup.add(this.getTokenAttribute(TEST_QUERY.substring(0, 4), 0, 4));
        tokenSequenceWithRepeatedGroup.add(this.getTokenAttribute(TEST_QUERY.substring(5, 6), 5, 6));
        tokenSequenceWithRepeatedGroup.add(this.getTokenAttribute(TEST_QUERY.substring(6, 10), 6, 10));
        tokenSequenceWithRepeatedGroup.add(this.getTokenAttribute(TEST_QUERY.substring(10, 11), 10, 11));
        Assert.assertTrue((String)"All tokens in test data must be sequentially shifted", (boolean)this.parser.isAllTokensSequentiallyShifted(tokenSequenceWithRepeatedGroup));
        Assert.assertTrue((boolean)this.parser.getEnablePositionIncrements());
        LinkedList<LinkedList<PackedTokenAttributeImpl>> fixedTokenSequences = new LinkedList<LinkedList<PackedTokenAttributeImpl>>();
        fixedTokenSequences.add(tokenSequenceWithRepeatedGroup);
        SpanQuery q = this.parser.generateSpanOrQuery(TEST_FIELD, fixedTokenSequences);
        Assert.assertNotNull((Object)q);
        Assert.assertTrue((boolean)(q instanceof SpanNearQuery));
        SpanNearQuery spanNearQuery = (SpanNearQuery)q;
        Assert.assertEquals((String)"Slop between term must be 0", (long)0L, (long)spanNearQuery.getSlop());
        Assert.assertTrue((String)"Terms must be in order", (boolean)spanNearQuery.isInOrder());
        SpanQuery[] termClauses = spanNearQuery.getClauses();
        Assert.assertEquals((String)("Flat query must be generated (Query: " + String.valueOf(q) + ")"), (long)tokenSequenceWithRepeatedGroup.size(), (long)termClauses.length);
        for (int i = 0; i < termClauses.length; ++i) {
            Assert.assertTrue((boolean)(termClauses[i] instanceof SpanTermQuery));
            Assert.assertEquals((String)"All tokens must become spanQuery terms", (Object)((PackedTokenAttributeImpl)tokenSequenceWithRepeatedGroup.get(i)).toString(), (Object)((SpanTermQuery)termClauses[i]).getTerm().text());
        }
    }
}

