/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import java.util.HashMap;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.requestHandler.AbstractRequestHandlerIT;
import org.alfresco.util.Pair;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AFTSRangeQueryIT
extends AbstractRequestHandlerIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestDataProvider dataProvider = new TestDataProvider(h);
        Pair[] ratingsAndCreators = new Pair[]{new Pair((Object)"someTest", (Object)"Mario"), new Pair((Object)"test", (Object)"Luigi"), new Pair((Object)"firstString", (Object)"Wario")};
        TEST_ROOT_NODEREF = dataProvider.getRootNode();
        IntStream.range(0, ratingsAndCreators.length).forEach(dbId -> {
            String rating = (String)ratingsAndCreators[dbId].getFirst();
            String creator = (String)ratingsAndCreators[dbId].getSecond();
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_CREATOR, (PropertyValue)new StringPropertyValue(creator));
            properties.put(ContentModel.PROP_RATING_SCHEME, (PropertyValue)new StringPropertyValue(rating));
            AlfrescoSolrUtils.addNode(AFTSRangeQueryIT.getCore(), dataModel, 1, dbId, 1, ContentModel.TYPE_CONTENT, null, properties, null, "the_owner_of_this_node_is" + creator, null, new NodeRef[]{TEST_ROOT_NODEREF}, new String[]{"/" + String.valueOf(dataProvider.qName("a_qname_for_node_" + creator))}, dataProvider.newNodeRef(), true);
        });
    }

    @Test
    public void testRangeQueriesNonTokenised() {
        this.assertResponseCardinality("cm:ratingScheme:[n TO *]", 2);
        this.assertResponseCardinality("cm:ratingScheme:[* TO n]", 1);
        this.assertResponseCardinality("cm:ratingScheme:[first TO *]", 3);
        this.assertResponseCardinality("cm:ratingScheme:[firstt TO *]", 2);
        this.assertResponseCardinality("cm:ratingScheme:[* TO someTest]", 2);
        this.assertResponseCardinality("cm:ratingScheme:[kk TO someTest]", 1);
    }

    @Test
    public void testRangeQueriesTokenised() {
        this.assertResponseCardinality("cm:creator:[Mario TO *]", 2);
        this.assertResponseCardinality("cm:creator:[Lu TO *]", 3);
        this.assertResponseCardinality("cm:creator:[Luigi2 TO Mario]", 1);
        this.assertResponseCardinality("cm:creator:[* TO Mario]", 2);
    }
}

