/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.apache.solr.request.SolrQueryRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractRequestHandlerIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void spinUpSolr() throws Exception {
        AbstractRequestHandlerIT.initAlfrescoCore("schema.xml");
        Thread.sleep(1000L);
    }

    void assertAQueryHasNumOfDocsWithJson(String query, String json, int num) {
        AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params("rows", "20", "qt", "/afts", "fq", "{!afts}AUTHORITY_FILTER_FROM_JSON", "q", query), json), "*[count(//doc)=" + num + "]");
    }

    void assertResponseException(String query, String exceptionMessage) {
        try {
            h.query((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", query), null));
            Assert.fail((String)"No Exception Thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)exceptionMessage));
        }
    }

    void assertResponseCardinality(String query, int num) {
        AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", query), null), "*[count(//doc)=" + num + "]");
    }

    void assertResponseCardinality(String field, String value, int expectedCardinality) {
        this.assertResponseCardinality(field + ":" + value, expectedCardinality);
    }

    void assertResponseCardinality(String field, String value, String filterQuery, int expectedCardinality) {
        String query = field + ":" + value;
        AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params("rows", "20", "qt", "/afts", "q", query, "fq", filterQuery), null), "*[count(//doc)=" + expectedCardinality + "]");
    }

    void assertAQueryIsSorted(String query, String sort, Locale aLocale, int num, Integer[] sortOrder) {
        List<String> xpaths = Stream.concat(Stream.of("*[count(//doc)=" + num + "]"), IntStream.range(1, sortOrder.length).filter(index -> sortOrder[index - 1] != null).mapToObj(index -> "//result/doc[" + index + "]/long[@name='DBID'][.='" + sortOrder[index - 1] + "']")).collect(Collectors.toList());
        String[] params = new String[]{"rows", "20", "qt", "/afts", "q", query, "sort", sort};
        if (aLocale != null) {
            ArrayList<String> localparams = new ArrayList<String>(Arrays.asList(params));
            localparams.add("locale");
            localparams.add(aLocale.toString());
            AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params(localparams.toArray(new String[0])), null), xpaths.toArray(new String[0]));
        } else {
            AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params(params), null), xpaths.toArray(new String[0]));
        }
    }

    void assertPage(String query, String sort, int num, int rows, int start, int[] sortOrder) {
        String[] params = new String[]{"start", Integer.toString(start), "rows", Integer.toString(rows), "qt", "/afts", "q", query, "sort", sort};
        AbstractRequestHandlerIT.assertQ((SolrQueryRequest)this.areq(AbstractRequestHandlerIT.params(params), null), (String[])Stream.concat(Stream.of("*[count(//doc)=" + num + "]"), IntStream.range(1, sortOrder.length).mapToObj(index -> "//result/doc[" + index + "]/long[@name='DBID'][.='" + sortOrder[index - 1] + "']")).toArray(String[]::new));
    }
}

