/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.CommitTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.Tracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ActivatableTrackerTest {
    private ActivatableTracker tracker;
    private TrackerState state;

    @Before
    public void setUp() {
        this.state = new TrackerState();
        this.state.setRunning(false);
        this.tracker = (ActivatableTracker)Mockito.spy((Object)((Object)new TestActivatableTracker(new Properties(), this.state)));
        this.tracker.enable();
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        Assert.assertFalse((boolean)this.tracker.state.isRunning());
    }

    @Test
    public void enabledShouldBeTheDefaultState() {
        Assert.assertTrue((boolean)this.tracker.isEnabled());
    }

    @Test
    public void trackersCanBeExplicitlyDisabled() {
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
    }

    @Test
    public void disablingATracker_shouldClearTheScheduledMaintenanceWork() {
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        ((ActivatableTracker)Mockito.verify((Object)this.tracker)).clearScheduledMaintenanceWork();
    }

    @Test
    public void enableIsIdempotent() {
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.enable();
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        this.tracker.enable();
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.enable();
        Assert.assertTrue((boolean)this.tracker.isEnabled());
    }

    @Test
    public void disableIsIdempotent() {
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        this.tracker.enable();
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        this.tracker.disable();
        Assert.assertFalse((boolean)this.tracker.isEnabled());
    }

    @Test
    public void disableIndexingOnRunningTracker_shouldDisableTheTrackerAnSetItInRollbackMode() {
        this.state.setRunning(true);
        Assert.assertTrue((boolean)this.tracker.isEnabled());
        Assert.assertTrue((boolean)this.tracker.state.isRunning());
        this.tracker.disable();
        this.state.setRunning(true);
        Assert.assertTrue((boolean)this.tracker.state.isRunning());
        Assert.assertFalse((boolean)this.tracker.isEnabled());
        ((ActivatableTracker)Mockito.verify((Object)this.tracker)).setRollback(true, null);
    }

    @Test
    public void assertActivatableTrackersList() {
        Stream.of(MetadataTracker.class, AclTracker.class, ContentTracker.class, CascadeTracker.class).forEach(clazz -> Assert.assertTrue((String)("Warning: " + String.valueOf(clazz) + " is supposed to be enabled/disabled"), (boolean)ActivatableTracker.class.isAssignableFrom((Class<?>)clazz)));
    }

    @Test
    public void assertAlwaysActivatedTrackersList() {
        Stream.of(CommitTracker.class, ModelTracker.class).forEach(clazz -> Assert.assertFalse((String)("Warning: " + String.valueOf(clazz) + " is not supposed to be enabled/disabled"), (boolean)ActivatableTracker.class.isAssignableFrom((Class<?>)clazz)));
    }

    private static class TestActivatableTracker
    extends ActivatableTracker {
        protected TestActivatableTracker(Properties properties, TrackerState state) {
            super(properties, (SOLRAPIClient)Mockito.mock(SOLRAPIClient.class), "thisIsTheCoreName", (InformationServer)Mockito.mock(InformationServer.class), Tracker.Type.NODE_STATE_PUBLISHER);
            this.state = state;
        }

        protected void doTrack(String iterationId) {
        }

        public void maintenance() {
        }

        public boolean hasMaintenance() {
            return false;
        }

        public Semaphore getWriteLock() {
            return null;
        }

        public Semaphore getRunLock() {
            return null;
        }
    }
}

