/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collection;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.tracker.AlfrescoSolrTrackerIT;
import org.alfresco.solr.tracker.CommitTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
@SolrTestCaseJ4.SuppressSSL
public class AlfrescoSolrTrackerRollbackIT
extends AbstractAlfrescoSolrIT {
    private static Log logger = LogFactory.getLog(AlfrescoSolrTrackerIT.class);
    private static long MAX_WAIT_TIME = 80000L;

    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoSolrTrackerRollbackIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void clearQueue() throws Exception {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    @Test
    @Ignore(value="https://issues.alfresco.com/jira/browse/SEARCH-2526")
    public void testTrackers() throws Exception {
        AlfrescoCoreAdminHandler alfrescoCoreAdminHandler = (AlfrescoCoreAdminHandler)AlfrescoSolrTrackerRollbackIT.getCore().getCoreContainer().getMultiCoreHandler();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, AlfrescoSolrUtils.list("joel"), AlfrescoSolrUtils.list("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, AlfrescoSolrUtils.list("jim"), AlfrescoSolrUtils.list("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, AlfrescoSolrUtils.list(acl, acl2), AlfrescoSolrUtils.list(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        TrackerRegistry trackerRegistry = alfrescoCoreAdminHandler.getTrackerRegistry();
        Collection trackers = trackerRegistry.getTrackersForCore(AlfrescoSolrTrackerRollbackIT.getCore().getName());
        MetadataTracker metadataTracker = null;
        CommitTracker commitTracker = null;
        for (Tracker tracker : trackers) {
            if (tracker instanceof MetadataTracker) {
                metadataTracker = (MetadataTracker)tracker;
                continue;
            }
            if (!(tracker instanceof CommitTracker)) continue;
            commitTracker = (CommitTracker)tracker;
        }
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 3, 1L);
        Node folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node errorNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, txn, acl, "mike", null, false);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
        NodeMetaData errorMetaData = AlfrescoSolrUtils.getNodeMetaData(errorNode, txn, acl, "lisa", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), true);
        AlfrescoSolrTrackerRollbackIT.indexTransaction(txn, AlfrescoSolrUtils.list(errorNode, folderNode, fileNode), AlfrescoSolrUtils.list(errorMetaData, folderMetaData, fileMetaData));
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)txn.getId(), (Long)(txn.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        waitForQuery = builder.build();
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(fileNode.getId()))), 1L, MAX_WAIT_TIME);
        commitTracker.getRunLock().acquire();
        Transaction rollbackTxn = AlfrescoSolrUtils.getTransaction(0, 1, 2L);
        Node rollbackNode = AlfrescoSolrUtils.getNode(rollbackTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData rollbackMetaData = AlfrescoSolrUtils.getNodeMetaData(rollbackNode, rollbackTxn, acl, "mike", null, false);
        AlfrescoSolrTrackerRollbackIT.indexTransaction(rollbackTxn, AlfrescoSolrUtils.list(rollbackNode), AlfrescoSolrUtils.list(rollbackMetaData));
        long cycles = metadataTracker.getTrackerState().getTrackerCycles();
        while ((long)metadataTracker.getTrackerState().getTrackerCycles() < cycles + 3L) {
            Thread.sleep(1000L);
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.remove(rollbackTxn);
        metadataTracker.setRollback(true, (Throwable)new Exception("Forced rollback!"));
        commitTracker.getRunLock().release();
        while (commitTracker.getRollbackCount() == 0) {
            Thread.sleep(1000L);
        }
        AclChangeSet afterRollbackAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 10L);
        Acl afterRollbackAcl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders afterRollbackAclReaders = AlfrescoSolrUtils.getAclReaders(afterRollbackAclChangeSet, afterRollbackAcl, AlfrescoSolrUtils.list("joel"), AlfrescoSolrUtils.list("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(afterRollbackAclChangeSet, AlfrescoSolrUtils.list(afterRollbackAcl), AlfrescoSolrUtils.list(afterRollbackAclReaders));
        Transaction afterRollbackTxn = AlfrescoSolrUtils.getTransaction(0, 1, 3L);
        Node afterRollbackNode = AlfrescoSolrUtils.getNode(afterRollbackTxn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData afterRollbackMetaData = AlfrescoSolrUtils.getNodeMetaData(afterRollbackNode, afterRollbackTxn, acl, "mike", null, false);
        AlfrescoSolrTrackerRollbackIT.indexTransaction(afterRollbackTxn, AlfrescoSolrUtils.list(afterRollbackNode), AlfrescoSolrUtils.list(afterRollbackMetaData));
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 3L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(afterRollbackNode.getId()))), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(rollbackNode.getId()))), 0L, MAX_WAIT_TIME);
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)afterRollbackAclChangeSet.getId(), (Long)(afterRollbackAclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        waitForQuery = builder.build();
        AlfrescoSolrTrackerRollbackIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
    }
}

