/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class ContentPropertyValueTrackerIT
extends AbstractAlfrescoDistributedIT {
    private final String authorField = "text@s__lt@{http://www.alfresco.org/model/content/1.0}author";

    @BeforeClass
    public static void initData() throws Throwable {
        ContentPropertyValueTrackerIT.initSolrServers(1, ContentPropertyValueTrackerIT.class.getSimpleName(), null);
    }

    @AfterClass
    public static void destroyData() {
        ContentPropertyValueTrackerIT.dismissSolrServers();
    }

    @Test
    public void testDataWithMultipleContentValueIsIndexedAfterUpdateTest() throws Exception {
        ContentPropertyValueTrackerIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, AlfrescoSolrUtils.list("joel"), AlfrescoSolrUtils.list("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, AlfrescoSolrUtils.list(acl), AlfrescoSolrUtils.list(aclReaders));
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 1);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", null, false);
        String author = "Mario";
        fileMetaData.getProperties().put(ContentModel.PROP_TITLE, new ContentPropertyValue(Locale.CANADA, 100L, "UTF8", "txt", Long.valueOf(10L)));
        fileMetaData.getProperties().put(ContentModel.PROP_AUTHOR, new StringPropertyValue(author));
        ContentPropertyValueTrackerIT.indexTransaction(txn, AlfrescoSolrUtils.list(fileNode), AlfrescoSolrUtils.list(fileMetaData));
        ContentPropertyValueTrackerIT.waitForDocCount((Query)new TermQuery(new Term("text@s__lt@{http://www.alfresco.org/model/content/1.0}author", author)), 1, AlfrescoSolrUtils.MAX_WAIT_TIME);
        Transaction txn1 = AlfrescoSolrUtils.getTransaction(0, 1);
        String authorAfterUpdate = "Luigi";
        fileMetaData.getProperties().put(ContentModel.PROP_AUTHOR, new StringPropertyValue(authorAfterUpdate));
        ContentPropertyValueTrackerIT.indexTransaction(txn1, AlfrescoSolrUtils.list(fileNode), AlfrescoSolrUtils.list(fileMetaData));
        ContentPropertyValueTrackerIT.waitForDocCount((Query)new TermQuery(new Term("text@s__lt@{http://www.alfresco.org/model/content/1.0}author", authorAfterUpdate)), 1, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }
}

