/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DBIDRouter;
import org.alfresco.solr.tracker.DateMonthRouter;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DateMonthRouterIT {
    private Random randomizer = new Random();
    private DocRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        this.router = DocRouterFactory.getRouter((Properties)new Properties(), (ShardMethodEnum)ShardMethodEnum.DATE);
    }

    @Test
    public void aclsAreReplicatedAcrossShards() {
        IntStream.range(0, 100).forEach(index -> Assert.assertTrue((boolean)this.router.routeAcl(this.randomizer.nextInt(), this.randomizer.nextInt(), this.acl)));
    }

    @Test
    public void invalidDate_shouldFallBackToDBIDRouting() {
        DBIDRouter fallbackRouting;
        ((DateMonthRouter)this.router).dbidRouter = fallbackRouting = (DBIDRouter)Mockito.mock(DBIDRouter.class);
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn((Object)"Something which is not an ISO Date");
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        this.router.routeNode(shardCount, shardInstance, this.node);
        ((DBIDRouter)Mockito.verify((Object)fallbackRouting)).routeNode(shardCount, shardInstance, this.node);
    }

    @Test
    public void nullDate_shouldFallBackToDBIDRouting() {
        DBIDRouter fallbackRouting;
        ((DateMonthRouter)this.router).dbidRouter = fallbackRouting = (DBIDRouter)Mockito.mock(DBIDRouter.class);
        Mockito.when((Object)this.node.getShardPropertyValue()).thenReturn(null);
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        this.router.routeNode(shardCount, shardInstance, this.node);
        ((DBIDRouter)Mockito.verify((Object)fallbackRouting)).routeNode(shardCount, shardInstance, this.node);
    }

    @Test
    public void twelveShardsInTheCluster_shouldBalanceNodes() {
        int[] shardIdentifiers = IntStream.range(0, 12).toArray();
        int shardCount = shardIdentifiers.length;
        this.router.routeNode(shardCount, 0, this.node);
        int howManyDocuments = shardCount * 10000;
        HashMap nodeDistributionMap = new HashMap();
        IntStream.range(0, howManyDocuments).mapToLong(Long::valueOf).forEach(id -> {
            String date = ISO8601DateFormat.format((Date)new Date(System.currentTimeMillis() + id * 2592000000L));
            Node node = new Node();
            node.setShardPropertyValue(date);
            Arrays.stream(shardIdentifiers).forEach(shardId -> {
                if (this.router.routeNode(shardCount, shardId, node).booleanValue()) {
                    nodeDistributionMap.merge(shardId, 1, Integer::sum);
                }
            });
        });
        StandardDeviation sd = new StandardDeviation();
        double deviation = sd.evaluate(nodeDistributionMap.values().stream().mapToDouble(Number::doubleValue).toArray());
        Assert.assertEquals((long)shardIdentifiers.length, (long)nodeDistributionMap.size());
        Assert.assertTrue((String)(nodeDistributionMap.values().toString() + ", SD = " + deviation), (deviation / (double)(howManyDocuments / shardCount) * 100.0 < 30.0 ? 1 : 0) != 0);
    }
}

