/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.SolrCore;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
@SolrTestCaseJ4.SuppressObjectReleaseTracker(bugUrl="RAMDirectory")
public class DistributedExplicitShardRoutingTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedExplicitShardRoutingTrackerIT.initSolrServers(3, DistributedExplicitShardRoutingTrackerIT.getSimpleClassName(), DistributedExplicitShardRoutingTrackerIT.getProperties());
    }

    @AfterClass
    public static void destroyData() {
        DistributedExplicitShardRoutingTrackerIT.dismissSolrServers();
    }

    @Test
    public void testShardId() throws Exception {
        DistributedExplicitShardRoutingTrackerIT.putHandleDefaults();
        int numAcls = 25;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i = 0; i < numAcls; ++i) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("king" + bulkAcl.getId()), Collections.singletonList("king" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (int i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            Node node = AlfrescoSolrUtils.getNode(bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "king", null, false);
            boolean even = i % 2 == 0;
            node.setShardPropertyValue(even ? "1" : "0");
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedExplicitShardRoutingTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        TermQuery contentQuery = new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world"));
        TermQuery aclQuery = new TermQuery(new Term("DOC_TYPE", "Acl"));
        Collection<SolrCore> shards = DistributedExplicitShardRoutingTrackerIT.getCores(solrShards);
        List<SolrClient> shardClients = DistributedExplicitShardRoutingTrackerIT.getShardedClients();
        long begin = System.currentTimeMillis();
        DistributedExplicitShardRoutingTrackerIT.waitForDocCountAllCores((Query)aclQuery, numAcls, 25000L);
        DistributedExplicitShardRoutingTrackerIT.waitForShardsCount((Query)contentQuery, numNodes, 20000L, begin);
        begin = System.currentTimeMillis();
        block9: for (int i = 0; i < shardClients.size(); ++i) {
            int shardId = i;
            SolrCore core = shards.stream().filter(solrcore -> solrcore.getName().endsWith("" + shardId)).findAny().orElseThrow(RuntimeException::new);
            SolrClient client = shardClients.get(i);
            switch (core.getName()) {
                case "shard0": 
                case "shard1": {
                    DistributedExplicitShardRoutingTrackerIT.waitForDocCountCore(client, (ModifiableSolrParams)DistributedExplicitShardRoutingTrackerIT.luceneToSolrQuery((Query)contentQuery), 500L, 1000L, begin);
                    continue block9;
                }
            }
        }
        DistributedExplicitShardRoutingTrackerIT.assertShardCount(2, (Query)contentQuery, 0);
        Transaction txn1 = AlfrescoSolrUtils.getTransaction(0, 2);
        ArrayList<Node> extraNodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> extraNodeMetaDatas = new ArrayList<NodeMetaData>();
        Node node = AlfrescoSolrUtils.getNode(txn1, (Acl)bulkAcls.get(1), Node.SolrApiNodeStatus.UPDATED);
        extraNodes.add(node);
        NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, txn1, (Acl)bulkAcls.get(1), "king", null, false);
        node.setShardPropertyValue("node YOU DON'T");
        extraNodeMetaDatas.add(nodeMetaData);
        node = AlfrescoSolrUtils.getNode(txn1, (Acl)bulkAcls.get(2), Node.SolrApiNodeStatus.UPDATED);
        extraNodes.add(node);
        nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, txn1, (Acl)bulkAcls.get(2), "king", null, false);
        extraNodeMetaDatas.add(nodeMetaData);
        DistributedExplicitShardRoutingTrackerIT.indexTransaction(txn1, extraNodes, extraNodeMetaDatas);
        begin = System.currentTimeMillis();
        DistributedExplicitShardRoutingTrackerIT.waitForShardsCount((Query)contentQuery, numNodes + 2, 30000L, begin);
    }

    protected static Properties getProperties() {
        Properties prop = new Properties();
        prop.put("shard.method", ShardMethodEnum.EXPLICIT_ID.toString());
        prop.put("shard.key", ContentModel.PROP_SKYPE.toString());
        return prop;
    }
}

