/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.alfresco.solr.tracker.TrackerStats;
import org.apache.commons.codec.EncoderException;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataTrackerTest {
    private static final Long TX_ID = 10000000L;
    private static final Long DB_ID = 999L;
    private MetadataTracker metadataTracker;
    @Mock
    private SOLRAPIClient repositoryClient;
    @Mock
    private InformationServer srv;
    @Spy
    private Properties props;
    @Mock
    private TrackerStats trackerStats;
    @Mock
    private TrackerState trackerState;

    @Before
    public void setUp() {
        ((Properties)Mockito.doReturn((Object)"0-2000").when((Object)this.props)).getProperty("solr.initial.transaction.range");
        ((Properties)Mockito.doReturn((Object)"workspace://SpacesStore").when((Object)this.props)).getProperty("alfresco.stores");
        Mockito.when((Object)this.srv.getTrackerStats()).thenReturn((Object)this.trackerStats);
        String coreName = "theCoreName";
        this.metadataTracker = (MetadataTracker)Mockito.spy((Object)new MetadataTracker(this.props, this.repositoryClient, coreName, this.srv));
        ModelTracker modelTracker = (ModelTracker)Mockito.mock(ModelTracker.class);
        TrackerRegistry registry = new TrackerRegistry();
        registry.setModelTracker(modelTracker);
        this.metadataTracker.state = this.trackerState;
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void doTrackWithOneTransactionUpdatesOnce() throws AuthenticationException, IOException, JSONException, EncoderException {
        TrackerState state = new TrackerState();
        state.setTimeToStopIndexing(2L);
        Mockito.when((Object)this.srv.getTrackerInitialState()).thenReturn((Object)state);
        Mockito.when((Object)this.metadataTracker.getTrackerState()).thenReturn((Object)state);
        ArrayList<Transaction> txsList = new ArrayList<Transaction>();
        Transaction tx = new Transaction();
        tx.setCommitTimeMs(1L);
        tx.setDeletes(1L);
        tx.setUpdates(1L);
        txsList.add(tx);
        Transactions txs = (Transactions)Mockito.mock(Transactions.class);
        Mockito.when((Object)txs.getTransactions()).thenReturn(txsList);
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt())).thenReturn((Object)txs).thenReturn((Object)txs).thenReturn((Object)((Transactions)Mockito.mock(Transactions.class)));
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt(), (ShardState)ArgumentMatchers.isNull())).thenReturn((Object)txs).thenReturn((Object)txs).thenReturn((Object)((Transactions)Mockito.mock(Transactions.class)));
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt(), (ShardState)ArgumentMatchers.any(ShardState.class))).thenReturn((Object)txs).thenReturn((Object)txs).thenReturn((Object)((Transactions)Mockito.mock(Transactions.class)));
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node = new Node();
        nodes.add(node);
        Mockito.when((Object)this.repositoryClient.getNodes((GetNodesParameters)ArgumentMatchers.any(GetNodesParameters.class), ArgumentMatchers.anyInt())).thenReturn(nodes);
        this.metadataTracker.doTrack("AnIterationId");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.srv});
        ((InformationServer)inOrder.verify((Object)this.srv)).indexNodes(nodes, true);
        ((InformationServer)inOrder.verify((Object)this.srv)).indexTransaction(tx, true);
        ((InformationServer)inOrder.verify((Object)this.srv)).commit();
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void doTrackWithNoTransactionsDoesNothing() throws AuthenticationException, IOException, JSONException, EncoderException {
        TrackerState state = new TrackerState();
        Mockito.when((Object)this.srv.getTrackerInitialState()).thenReturn((Object)state);
        Mockito.when((Object)this.metadataTracker.getTrackerState()).thenReturn((Object)state);
        Transactions txs = (Transactions)Mockito.mock(Transactions.class);
        ArrayList txsList = new ArrayList();
        Mockito.when((Object)txs.getTransactions()).thenReturn(txsList);
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt(), (ShardState)ArgumentMatchers.isNull())).thenReturn((Object)txs);
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt(), (ShardState)ArgumentMatchers.any(ShardState.class))).thenReturn((Object)txs);
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyInt())).thenReturn((Object)txs);
        this.metadataTracker.doTrack("AnIterationId");
        ((InformationServer)Mockito.verify((Object)this.srv, (VerificationMode)Mockito.never())).commit();
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void testCheckNodeLong() throws AuthenticationException, IOException, JSONException {
        List<Node> nodes = this.getNodes();
        Mockito.when((Object)this.repositoryClient.getNodes((GetNodesParameters)ArgumentMatchers.any(GetNodesParameters.class), ArgumentMatchers.eq((int)1))).thenReturn(nodes);
        NodeReport nodeReport = this.metadataTracker.checkNode(DB_ID);
        Assert.assertNotNull((Object)nodeReport);
        Assert.assertEquals((Object)DB_ID, (Object)nodeReport.getDbid());
        Assert.assertEquals((Object)TX_ID, (Object)nodeReport.getDbTx());
    }

    private List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node = this.getNode();
        nodes.add(node);
        return nodes;
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void testCheckNodeNode() {
        Node node = this.getNode();
        NodeReport nodeReport = this.metadataTracker.checkNode(node);
        Assert.assertNotNull((Object)nodeReport);
        Assert.assertEquals((Object)DB_ID, (Object)nodeReport.getDbid());
        Assert.assertEquals((Object)TX_ID, (Object)nodeReport.getDbTx());
    }

    @Test
    public void incomingCommitTimeIsLesserThanLastIndexedTxCommitTime_transactionShouldBeMarkedAsIndexed() throws Exception {
        long incomingTransactionCommitTime = 10L;
        long lastIndexedTransactionCommitTime = incomingTransactionCommitTime + 1L;
        Transaction incomingTransaction = new Transaction();
        incomingTransaction.setId(1L);
        incomingTransaction.setCommitTimeMs(incomingTransactionCommitTime);
        Mockito.when((Object)this.srv.txnInIndex(incomingTransaction.getId(), true)).thenReturn((Object)true);
        Mockito.when((Object)this.trackerState.getLastIndexedTxCommitTime()).thenReturn((Object)lastIndexedTransactionCommitTime);
        Assert.assertFalse((boolean)this.metadataTracker.isTransactionToBeIndexed(incomingTransaction));
    }

    @Test
    public void incomingCommitTimeIsLesserThanLastIndexedTxCommitTimeButTheTransactionIsNotIndexed_transactionShouldBeMarkedAsToBeIndexed() throws Exception {
        long incomingTransactionCommitTime = 10L;
        long lastIndexedTransactionCommitTime = incomingTransactionCommitTime + 1L;
        Transaction incomingTransaction = new Transaction();
        incomingTransaction.setId(1L);
        incomingTransaction.setCommitTimeMs(incomingTransactionCommitTime);
        Mockito.when((Object)this.srv.txnInIndex(incomingTransaction.getId(), true)).thenReturn((Object)false);
        Mockito.when((Object)this.trackerState.getLastIndexedTxCommitTime()).thenReturn((Object)lastIndexedTransactionCommitTime);
        Assert.assertTrue((boolean)this.metadataTracker.isTransactionToBeIndexed(incomingTransaction));
    }

    @Test
    public void incomingCommitTimeIsGreaterThanLastIndexedTxCommitTime_transactionShouldBeMarkedAsToBeIndexed() {
        long lastIndexedTransactionCommitTime = 10L;
        long incomingTransactionCommitTime = lastIndexedTransactionCommitTime + 1L;
        Transaction incomingTransaction = new Transaction();
        incomingTransaction.setId(1L);
        incomingTransaction.setCommitTimeMs(incomingTransactionCommitTime);
        Mockito.when((Object)this.trackerState.getLastIndexedTxCommitTime()).thenReturn((Object)lastIndexedTransactionCommitTime);
        Assert.assertTrue((boolean)this.metadataTracker.isTransactionToBeIndexed(incomingTransaction));
    }

    @Test
    public void incomingCommitTimeIsGreaterThanLastIndexedTxCommitTimeButTheTransactionIsAlreadyIndexed_transactionShouldBeMarkedAsToBeIndexed() {
        long lastIndexedTransactionCommitTime = 10L;
        long incomingTransactionCommitTime = lastIndexedTransactionCommitTime + 1L;
        Transaction incomingTransaction = new Transaction();
        incomingTransaction.setId(1L);
        incomingTransaction.setCommitTimeMs(incomingTransactionCommitTime);
        Mockito.when((Object)this.trackerState.getLastIndexedTxCommitTime()).thenReturn((Object)lastIndexedTransactionCommitTime);
        Assert.assertTrue((boolean)this.metadataTracker.isTransactionToBeIndexed(incomingTransaction));
    }

    @Test
    public void anIOExceptionIsRaised_transactionShouldBeMarkedAsToBeIndexed() throws Exception {
        long incomingTransactionCommitTime = 10L;
        long lastIndexedTransactionCommitTime = incomingTransactionCommitTime + 1L;
        Transaction incomingTransaction = new Transaction();
        incomingTransaction.setId(1L);
        incomingTransaction.setCommitTimeMs(incomingTransactionCommitTime);
        Mockito.when((Object)this.srv.txnInIndex(incomingTransaction.getId(), true)).thenThrow(new Throwable[]{new IOException()});
        Mockito.when((Object)this.trackerState.getLastIndexedTxCommitTime()).thenReturn((Object)lastIndexedTransactionCommitTime);
        Assert.assertTrue((boolean)this.metadataTracker.isTransactionToBeIndexed(incomingTransaction));
    }

    private Node getNode() {
        Node node = new Node();
        node.setId(DB_ID.longValue());
        node.setTxnId(TX_ID.longValue());
        return node;
    }

    @Test
    public void testCheckRepoAndIndexConsistency() throws AuthenticationException, IOException, JSONException {
        TrackerState state = new TrackerState();
        ModelTracker modelTracker = (ModelTracker)Mockito.mock(ModelTracker.class);
        Mockito.when((Object)modelTracker.hasModels()).thenReturn((Object)true);
        Mockito.when((Object)this.metadataTracker.getTrackerState()).thenReturn((Object)state);
        TrackerRegistry registry = new TrackerRegistry();
        registry.setModelTracker(modelTracker);
        AlfrescoCoreAdminHandler alfrescoCoreAdminHandler = (AlfrescoCoreAdminHandler)Mockito.mock(AlfrescoCoreAdminHandler.class);
        Mockito.when((Object)this.srv.getAdminHandler()).thenReturn((Object)alfrescoCoreAdminHandler);
        Mockito.when((Object)alfrescoCoreAdminHandler.getTrackerRegistry()).thenReturn((Object)registry);
        ArrayList<Transaction> txsList = new ArrayList<Transaction>();
        Transaction tx1 = new Transaction();
        tx1.setCommitTimeMs(1L);
        tx1.setDeletes(1L);
        tx1.setUpdates(1L);
        txsList.add(tx1);
        Transactions txs = new Transactions(txsList, Long.valueOf(0L), Long.valueOf(2000L));
        Mockito.when((Object)this.repositoryClient.getTransactions(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)txs);
        Mockito.when((Object)this.repositoryClient.getTransactions(Long.valueOf(1L), null, Long.valueOf(3600001L), null, 2000)).thenReturn((Object)txs);
        this.metadataTracker.doTrack("AnIterationId");
        ((MetadataTracker)Mockito.verify((Object)this.metadataTracker, (VerificationMode)Mockito.times((int)1))).doTrack("AnIterationId");
    }
}

