/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component.spellcheck;

import java.util.Collections;
import java.util.List;
import org.alfresco.solr.component.spellcheck.AlfrescoSpellCheckCollation;
import org.alfresco.solr.component.spellcheck.AlfrescoSpellCheckCollator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SpellCheckComponent;
import org.apache.solr.spelling.SpellingResult;

public class AlfrescoSpellCheckComponent
extends SpellCheckComponent {
    protected void addCollationsToResponse(SolrParams params, SpellingResult spellingResult, ResponseBuilder rb, String q, NamedList response, boolean suggestionsMayOverlap) {
        int maxCollations = params.getInt("spellcheck.maxCollations", 1);
        int maxCollationTries = params.getInt("spellcheck.maxCollationTries", 0);
        int maxCollationEvaluations = params.getInt("spellcheck.maxCollationEvaluations", 10000);
        boolean collationExtendedResults = params.getBool("spellcheck.collateExtendedResults", false);
        int maxCollationCollectDocs = params.getInt("spellcheck.collateMaxCollectDocs", 0);
        if (!collationExtendedResults) {
            maxCollationCollectDocs = 1;
        }
        boolean shard = params.getBool("isShard", false);
        AlfrescoSpellCheckCollator collator = new AlfrescoSpellCheckCollator();
        collator.setMaxCollations(maxCollations);
        collator.setMaxCollationTries(maxCollationTries);
        collator.setMaxCollationEvaluations(maxCollationEvaluations);
        collator.setSuggestionsMayOverlap(suggestionsMayOverlap);
        collator.setDocCollectionLimit(maxCollationCollectDocs);
        List<AlfrescoSpellCheckCollation> collations = collator.collate(spellingResult, q, rb);
        Collections.sort(collations);
        NamedList collationList = new NamedList();
        for (AlfrescoSpellCheckCollation collation : collations) {
            if (collationExtendedResults) {
                SimpleOrderedMap extendedResult = new SimpleOrderedMap();
                extendedResult.add("collationQuery", (Object)collation.getCollationQuery());
                extendedResult.add("hits", (Object)collation.getHits());
                extendedResult.add("misspellingsAndCorrections", (Object)collation.getMisspellingsAndCorrections());
                if (maxCollationTries > 0 && shard) {
                    extendedResult.add("collationInternalRank", (Object)collation.getInternalRank());
                }
                extendedResult.add("collationQueryString", (Object)collation.getCollationQueryString());
                collationList.add("collation", (Object)extendedResult);
                continue;
            }
            collationList.add("collation", (Object)collation.getCollationQuery());
            if (maxCollationTries <= 0 || !shard) continue;
            collationList.add("collationInternalRank", (Object)collation.getInternalRank());
        }
        NamedList suggestions = (NamedList)response.get("suggestions");
        suggestions.addAll(collationList);
        response.add("collations", (Object)collationList);
    }
}

