/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.schema.highlight;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.alfresco.solr.utils.Utils;

class CompositeReader
extends Reader {
    private final Iterator<Reader> iterator;
    private final List<Closeable> exhausted;
    private Reader current;

    public CompositeReader(Reader ... readers) {
        if (readers == null || readers.length == 0) {
            throw new IllegalArgumentException("At least one reader instance is needed.");
        }
        this.exhausted = Arrays.asList(readers);
        this.iterator = Arrays.asList(readers).iterator();
        this.current = this.iterator.next();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = this.current.read(cbuf, off, len);
        if (read == -1 && this.iterator.hasNext()) {
            this.current = this.iterator.next();
            read = this.current.read(cbuf, off, len);
        } else if (read < len && this.iterator.hasNext()) {
            this.current = this.iterator.next();
            read += this.current.read(cbuf, read, len - read);
        }
        return read;
    }

    @Override
    public void close() {
        this.exhausted.forEach(Utils::silentyClose);
    }
}

