/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.servlet.ServletContext;
import org.alfresco.web.scripts.servlet.X509ServletFilterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.core.SolrResourceLoader;

public class Solr4X509ServletFilter
extends X509ServletFilterBase {
    private static final String SECURE_COMMS = "alfresco.secureComms";
    private static Log logger = LogFactory.getLog(Solr4X509ServletFilter.class);
    static final int NOT_FOUND_HTTPS_PORT_NUMBER = -1;
    private Function<ObjectName, Integer> extractPortNumber = name -> {
        try {
            return Optional.ofNullable(this.mxServer().getAttribute((ObjectName)name, "Port")).map(Number.class::cast).map(Number::intValue).orElse(-1);
        }
        catch (Exception exception) {
            logger.error((Object)("Error getting https port from MBean " + String.valueOf(name)), (Throwable)exception);
            return -1;
        }
    };

    protected boolean checkEnforce(ServletContext context) throws IOException {
        int httpsPort = this.getHttpsPort();
        if (httpsPort > -1) {
            this.setHttpsPort(httpsPort);
        }
        String solrHome = SolrResourceLoader.locateSolrHome().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("solrHome:" + solrHome));
        }
        ArrayList<File> cores = new ArrayList<File>();
        this.findCores(new File(solrHome), cores);
        HashSet<String> secureCommsSet = new HashSet<String>();
        for (File core : cores) {
            this.collectSecureComms(core, secureCommsSet);
        }
        if (secureCommsSet.size() > 1) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            for (String s : secureCommsSet) {
                if (i > 0) {
                    buf.append(" | ");
                }
                buf.append(s);
                ++i;
            }
            throw new IOException("More then one distinct value found for alfresco.secureComms:" + buf.toString() + ". All alfresco.secureComms values must be set to the same value.");
        }
        if (secureCommsSet.size() == 0) {
            return false;
        }
        String secureComms = (String)secureCommsSet.iterator().next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("secureComms:" + secureComms));
        }
        return !"none".equals(secureComms);
    }

    private void findCores(File dir, List<File> cores) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.findCores(file, cores);
                    continue;
                }
                if (!"core.properties".equals(file.getName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found core:" + dir.getAbsolutePath()));
                }
                cores.add(dir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectSecureComms(File base, Set<String> secureCommsSet) throws IOException {
        File[] files = base.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.collectSecureComms(file, secureCommsSet);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("scanning file:" + file.getAbsolutePath()));
                }
                if (!"solrcore.properties".equals(file.getName())) continue;
                Properties props = new Properties();
                try (FileReader propReader = null;){
                    propReader = new FileReader(file);
                    props.load(propReader);
                    String prop = props.getProperty(SECURE_COMMS);
                    if (prop != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found alfresco.secureComms in:" + file.getAbsolutePath() + " : " + prop));
                        }
                        secureCommsSet.add(prop);
                        continue;
                    }
                    secureCommsSet.add("none");
                }
            }
        }
    }

    int getHttpsPort() {
        return this.connectorMBeanName().map(this.extractPortNumber).orElse(-1);
    }

    Optional<ObjectName> connectorMBeanName() {
        try {
            QueryExp query = Query.eq(Query.attr("Scheme"), Query.value("https"));
            Set<ObjectName> connectors = this.mxServer().queryNames(null, query);
            return connectors.stream().findFirst();
        }
        catch (Exception exception) {
            logger.error((Object)"Error getting the Connector MBean.", (Throwable)exception);
            return Optional.empty();
        }
    }

    MBeanServer mxServer() {
        return Optional.ofNullable(MBeanServerFactory.findMBeanServer(null)).filter(servers -> !servers.isEmpty()).map(Collection::iterator).map(Iterator::next).orElseThrow(NoSuchElementException::new);
    }
}

