/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.config.ConfigUtil;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.Tracker;
import org.apache.solr.core.SolrResourceLoader;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTracker
extends AbstractTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelTracker.class);
    private final Set<StoreRef> indexedStores = new HashSet<StoreRef>();
    private final Set<StoreRef> ignoredStores = new HashSet<StoreRef>();
    private final Set<String> indexedTenants = new HashSet<String>();
    private final Set<String> ignoredTenants = new HashSet<String>();
    private final Set<QName> indexedDataTypes = new HashSet<QName>();
    private final Set<QName> ignoredDataTypes = new HashSet<QName>();
    private final Set<QName> indexedTypes = new HashSet<QName>();
    private final Set<QName> ignoredTypes = new HashSet<QName>();
    private final Set<QName> indexedAspects = new HashSet<QName>();
    private final Set<QName> ignoredAspects = new HashSet<QName>();
    private final Set<String> indexedFields = new HashSet<String>();
    private final Set<String> ignoredFields = new HashSet<String>();
    private ReentrantReadWriteLock modelLock = new ReentrantReadWriteLock();
    private volatile boolean hasModels = false;
    private File alfrescoModelDir;
    private static Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    public ModelTracker(String solrHome, Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer) {
        super(p, client, coreName, informationServer, Tracker.Type.MODEL);
        String normalSolrHome = SolrResourceLoader.normalizeDir((String)solrHome);
        this.alfrescoModelDir = new File(ConfigUtil.locateProperty("solr.model.dir", normalSolrHome + "alfrescoModels"));
        LOGGER.info("Alfresco Model dir {}", (Object)this.alfrescoModelDir);
        if (!this.alfrescoModelDir.exists()) {
            this.alfrescoModelDir.mkdir();
        }
        this.loadPersistedModels();
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
    }

    @Override
    public boolean hasMaintenance() {
        return false;
    }

    @Override
    public void maintenance() {
    }

    private void loadPersistedModels() {
        FileFilter filter;
        File[] files;
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        if (this.alfrescoModelDir.exists() && this.alfrescoModelDir.isDirectory() && (files = this.alfrescoModelDir.listFiles(filter = pathname -> pathname.isFile() && pathname.getName().endsWith(".xml"))) != null) {
            for (File file : files) {
                M2Model model;
                FileInputStream modelStream = null;
                try {
                    modelStream = new FileInputStream(file);
                    model = M2Model.createModel((InputStream)modelStream);
                }
                catch (IOException e) {
                    throw new AlfrescoRuntimeException("File not found: " + String.valueOf(file), (Throwable)e);
                }
                finally {
                    if (modelStream != null) {
                        try {
                            ((InputStream)modelStream).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                for (M2Namespace namespace : model.getNamespaces()) {
                    modelMap.put(namespace.getUri(), model);
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model);
        }
        if (modelMap.size() > 0) {
            AlfrescoSolrDataModel.getInstance().afterInitModels();
        }
    }

    ModelTracker() {
        super(Tracker.Type.MODEL);
    }

    @Override
    protected void doTrack(String iterationId) throws AuthenticationException, IOException, JSONException {
        int registeredSearcherCount = this.infoSrv.getRegisteredSearcherCount();
        if (registeredSearcherCount >= this.getMaxLiveSearchers()) {
            LOGGER.info(".... skipping tracking registered searcher count = {}", (Object)registeredSearcherCount);
            return;
        }
        this.checkShutdown();
        this.trackModels(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackModels(boolean onlyFirstTime) throws AuthenticationException, IOException, JSONException {
        boolean requiresWriteLock;
        this.modelLock.readLock().lock();
        try {
            if (this.hasModels) {
                if (onlyFirstTime) {
                    return;
                }
                requiresWriteLock = false;
            } else {
                requiresWriteLock = true;
            }
        }
        finally {
            this.modelLock.readLock().unlock();
        }
        if (requiresWriteLock) {
            this.modelLock.writeLock().lock();
            try {
                if (this.hasModels && onlyFirstTime) {
                    return;
                }
                this.trackModelsImpl();
                if (onlyFirstTime) {
                    this.infoSrv.initSkippingDescendantDocs();
                }
                this.hasModels = true;
            }
            finally {
                this.modelLock.writeLock().unlock();
            }
        } else {
            this.trackModelsImpl();
        }
    }

    public void ensureFirstModelSync() {
        try {
            this.trackModels(true);
        }
        catch (Throwable t) {
            LOGGER.error("Model tracking failed for core: {}", (Object)this.coreName, (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackModelsImpl() throws AuthenticationException, IOException, JSONException {
        long start = System.nanoTime();
        List modelDiffs = this.client.getModelsDiff(this.coreName, this.infoSrv.getAlfrescoModels());
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        block11: for (Object modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: 
                case NEW: {
                    M2Model model = this.client.getModel(this.coreName, modelDiff.getModelName());
                    for (M2Namespace namespace : model.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), model.getModel());
                    }
                    continue block11;
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model);
        }
        if (loadedModels.size() > 0) {
            this.infoSrv.afterInitModels();
        }
        block14: for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    this.removeMatchingModels(this.alfrescoModelDir, modelDiff.getModelName());
                    M2Model changedModel = this.infoSrv.getM2Model(modelDiff.getModelName());
                    File changedFile = new File(this.alfrescoModelDir, this.getModelFileName(changedModel));
                    FileOutputStream cos = new FileOutputStream(changedFile);
                    changedModel.toXML((OutputStream)cos);
                    cos.flush();
                    cos.close();
                    break;
                }
                case NEW: {
                    M2Model newModel = this.infoSrv.getM2Model(modelDiff.getModelName());
                    File newFile = new File(this.alfrescoModelDir, this.getModelFileName(newModel));
                    FileOutputStream nos = new FileOutputStream(newFile);
                    newModel.toXML((OutputStream)nos);
                    nos.flush();
                    nos.close();
                    break;
                }
                case REMOVED: {
                    try {
                        this.removeMatchingModels(this.alfrescoModelDir, modelDiff.getModelName());
                        continue block14;
                    }
                    finally {
                        AlfrescoSolrDataModel.getInstance().removeModel(modelDiff.getModelName());
                        continue block14;
                    }
                }
            }
        }
        long end = System.nanoTime();
        this.trackerStats.addModelTime(end - start);
        if (this.runPostModelLoadInit) {
            for (Object key : this.props.keySet()) {
                String name;
                QName qname;
                StoreRef store;
                String stringKey = (String)key;
                if (stringKey.startsWith("alfresco.index.store")) {
                    store = new StoreRef(this.props.getProperty(stringKey));
                    this.indexedStores.add(store);
                }
                if (stringKey.startsWith("alfresco.ignore.store")) {
                    store = new StoreRef(this.props.getProperty(stringKey));
                    this.ignoredStores.add(store);
                }
                if (stringKey.startsWith("alfresco.index.tenant")) {
                    this.indexedTenants.add(this.props.getProperty(stringKey));
                }
                if (stringKey.startsWith("alfresco.ignore.tenant")) {
                    this.ignoredTenants.add(this.props.getProperty(stringKey));
                }
                if (stringKey.startsWith("alfresco.index.datatype")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.indexedDataTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.datatype")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.ignoredDataTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.type")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.indexedTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.type")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.ignoredTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.aspect")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.indexedAspects.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.aspect")) {
                    qname = this.expandQName(this.props.getProperty(stringKey));
                    this.ignoredAspects.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.field")) {
                    name = this.expandName(this.props.getProperty(stringKey));
                    this.indexedFields.add(name);
                }
                if (!stringKey.startsWith("alfresco.ignore.field")) continue;
                name = this.expandName(this.props.getProperty(stringKey));
                this.ignoredFields.add(name);
            }
            this.runPostModelLoadInit = false;
        }
    }

    private QName expandQName(String qName) {
        String expandedQName = qName;
        if (qName.startsWith("@")) {
            return this.expandQName(qName.substring(1));
        }
        if (qName.startsWith("{")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (qName.contains(":")) {
            expandedQName = this.expandQNameImpl(qName);
        }
        return QName.createQName((String)expandedQName);
    }

    private String expandQNameImpl(String q) {
        Object eq = q;
        if (q.charAt(0) != '{') {
            int colonPosition = q.indexOf(58);
            eq = colonPosition == -1 ? "{" + this.infoSrv.getNamespaceDAO().getNamespaceURI("") + "}" + q : "{" + this.infoSrv.getNamespaceDAO().getNamespaceURI(q.substring(0, colonPosition)) + "}" + q.substring(colonPosition + 1);
        }
        return eq;
    }

    private String expandName(String qName) {
        String expandedQName = qName;
        if (qName.startsWith("@")) {
            return this.expandName(qName.substring(1));
        }
        if (qName.startsWith("{")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (qName.contains(":")) {
            expandedQName = this.expandQNameImpl(qName);
        }
        return expandedQName;
    }

    private void removeMatchingModels(File alfrescoModelDir, QName modelName) {
        String prefix = modelName.toPrefixString((NamespacePrefixResolver)this.infoSrv.getNamespaceDAO()).replace(":", ".") + ".";
        String postFix = ".xml";
        File[] toDelete = alfrescoModelDir.listFiles(pathname -> {
            if (pathname.isDirectory()) {
                return false;
            }
            String name = pathname.getName();
            if (!name.endsWith(".xml")) {
                return false;
            }
            if (!name.startsWith(prefix)) {
                return false;
            }
            String checksum = name.substring(prefix.length(), name.length() - ".xml".length());
            try {
                Long.parseLong(checksum);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        });
        if (toDelete != null) {
            for (File file : toDelete) {
                file.delete();
            }
        }
    }

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel);
            }
            if (this.infoSrv.putModel(model)) {
                loadedModels.add(modelName);
            }
            LOGGER.info("Loading model {}", (Object)model.getName());
        }
    }

    private String getModelFileName(M2Model model) {
        return model.getName().replace(":", ".") + "." + model.getChecksum(ModelDefinition.XMLBindingType.DEFAULT) + ".xml";
    }

    public boolean hasModels() {
        return this.hasModels;
    }
}

