/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.analysis.PathTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class PathTokenFilterTest
extends TestCase {
    public PathTokenFilterTest() {
    }

    public PathTokenFilterTest(String arg0) {
        super(arg0);
    }

    public void testFullPath() throws IOException {
        this.tokenise("{uri1}one", new String[]{"uri1", "one"});
        this.tokenise("/{uri1}one", new String[]{"uri1", "one"});
        this.tokenise("{uri1}one/{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/{uri1}one/{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("{uri1}one/{uri2}two/{uri3}three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/{uri1}one/{uri2}two/{uri3}three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPrefixPath() throws IOException {
        this.tokenise("uri1:one", new String[]{"uri1", "one"});
        this.tokenise("/uri1:one", new String[]{"uri1", "one"});
        this.tokenise("uri1:one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/uri1:one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("uri1:one/uri2:two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/uri1:one/uri2:two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMixedPath() throws IOException {
        this.tokenise("{uri1}one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/{uri1}one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("uri1:one/{uri2}two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/uri1:one/{uri2}two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTokenizerReuse() throws IOException {
        String path = "uri1:one";
        StringReader reader = new StringReader("uri1:one");
        PathTokenFilter ts = new PathTokenFilter(';', ";", "<No Namespace>", '{', '}', true);
        ts.setReader((Reader)reader);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        this.tokenise((TokenStream)ts, new String[]{"uri1", "one"});
        PathTokenFilterTest.assertEquals((int)"uri1:one".length(), (int)offsetAtt.startOffset());
        PathTokenFilterTest.assertEquals((int)"uri1:one".length(), (int)offsetAtt.endOffset());
        String path2 = "/{uri1}one/uri2:two/";
        StringReader reader2 = new StringReader("/{uri1}one/uri2:two/");
        ts.setReader((Reader)reader2);
        this.tokenise((TokenStream)ts, new String[]{"uri1", "one", "uri2", "two"});
        PathTokenFilterTest.assertEquals((int)"/{uri1}one/uri2:two/".length(), (int)offsetAtt.startOffset());
        PathTokenFilterTest.assertEquals((int)"/{uri1}one/uri2:two/".length(), (int)offsetAtt.endOffset());
    }

    public void testAttributesAfterStreamEnd() throws IOException {
        String path = "uri1:one";
        StringReader reader = new StringReader("uri1:one");
        PathTokenFilter ts = new PathTokenFilter(';', ";", "<No Namespace>", '{', '}', true);
        ts.setReader((Reader)reader);
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)ts.addAttribute(TypeAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
        this.tokenise((TokenStream)ts, new String[]{"uri1", "one"});
        PathTokenFilterTest.assertEquals((String)"", (String)termAtt.toString());
        PathTokenFilterTest.assertEquals((String)"word", (String)typeAtt.type());
        PathTokenFilterTest.assertEquals((int)0, (int)posIncAtt.getPositionIncrement());
        PathTokenFilterTest.assertEquals((int)"uri1:one".length(), (int)offsetAtt.startOffset());
        PathTokenFilterTest.assertEquals((int)"uri1:one".length(), (int)offsetAtt.endOffset());
    }

    private void tokenise(String path, String[] tokens) throws IOException {
        StringReader reader = new StringReader(path);
        PathTokenFilter ts = new PathTokenFilter(';', ";", "<No Namespace>", '{', '}', true);
        ts.setReader((Reader)reader);
        this.tokenise((TokenStream)ts, tokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tokenise(TokenStream ts, String[] tokens) throws IOException {
        int i = 0;
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)ts.addAttribute(TypeAttribute.class);
        try {
            ts.reset();
            while (ts.incrementToken()) {
                System.out.println("token: " + ts.reflectAsString(true));
                String termText = termAtt.toString();
                if (typeAtt.type().equals("PATH_ELEMENT_NAMESPACE")) {
                    assert (i % 2 == 0);
                    PathTokenFilterTest.assertEquals((String)termText, (String)tokens[i++]);
                    continue;
                }
                if (typeAtt.type().equals("PATH_ELEMENT_NAMESPACE_PREFIX")) {
                    assert (i % 2 == 0);
                    PathTokenFilterTest.assertEquals((String)termText, (String)tokens[i++]);
                    continue;
                }
                if (!typeAtt.type().equals("PATH_ELEMENT_NAME")) continue;
                assert (i % 2 == 1);
                PathTokenFilterTest.assertEquals((String)termText, (String)tokens[i++]);
            }
            ts.end();
        }
        finally {
            ts.close();
        }
        if (i != tokens.length) {
            PathTokenFilterTest.fail((String)("Invalid number of tokens, found " + i + " and expected " + tokens.length));
        }
    }
}

