/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlfrescoSolrFingerprintIT
extends AbstractAlfrescoSolrIT {
    private static long MAX_WAIT_TIME = 80000L;
    private Acl acl;

    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoSolrFingerprintIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void prepare() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        this.acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, this.acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(this.acl, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
    }

    @After
    public void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
        SOLRAPIQueueClient.NODE_CONTENT_MAP.clear();
        this.clearIndex();
        this.assertU(AlfrescoSolrFingerprintIT.commit(new String[0]));
    }

    private void makeSureTransactionHasBeenIndexed(long transactionId) throws Exception {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)transactionId, (Long)(transactionId + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
    }

    @Test
    public void testBasicFingerprint() throws Exception {
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 4);
        Node node1 = AlfrescoSolrUtils.getNode(txn, this.acl, Node.SolrApiNodeStatus.UPDATED);
        Node node2 = AlfrescoSolrUtils.getNode(txn, this.acl, Node.SolrApiNodeStatus.UPDATED);
        Node node3 = AlfrescoSolrUtils.getNode(txn, this.acl, Node.SolrApiNodeStatus.UPDATED);
        Node node4 = AlfrescoSolrUtils.getNode(txn, this.acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData nodeMetaData1 = AlfrescoSolrUtils.getNodeMetaData(node1, txn, this.acl, "mike", null, false);
        NodeMetaData nodeMetaData2 = AlfrescoSolrUtils.getNodeMetaData(node2, txn, this.acl, "mike", null, false);
        NodeMetaData nodeMetaData3 = AlfrescoSolrUtils.getNodeMetaData(node3, txn, this.acl, "mike", null, false);
        NodeMetaData nodeMetaData4 = AlfrescoSolrUtils.getNodeMetaData(node4, txn, this.acl, "mike", null, false);
        Random randomizer = new Random(1L);
        String aFirstToken = Integer.toString(Math.abs(randomizer.nextInt()));
        AlfrescoSolrFingerprintIT.indexTransaction(txn, Arrays.asList(node1, node2, node3, node4), Arrays.asList(nodeMetaData1, nodeMetaData2, nodeMetaData3, nodeMetaData4), this.randomTextContent());
        this.makeSureTransactionHasBeenIndexed(txn.getId());
        this.makeSureContentNodesHaveBeenIndexed("mike", aFirstToken, 4);
        this.assertFingerprintQueryCorrectness(node1.getId(), "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
        this.assertFingerprintQueryCorrectness(nodeMetaData1.getNodeRef().getId(), "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
        this.assertFingerprintQueryCorrectness(node1.getId() + "_70", "*[count(//doc)= 2]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node3.getId() + "']");
        this.assertFingerprintQueryCorrectness(nodeMetaData1.getNodeRef().getId() + "_70", "*[count(//doc)= 2]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node3.getId() + "']");
        this.assertFingerprintQueryCorrectness(node1.getId() + "_45", "*[count(//doc)= 3]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']");
        this.assertFingerprintQueryCorrectness(nodeMetaData1.getNodeRef().getId() + "_45", "*[count(//doc)= 3]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']");
        this.assertFingerprintQueryCorrectness(node4.getId() + "_30", "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
        this.assertFingerprintQueryCorrectness(nodeMetaData4.getNodeRef().getId() + "_30", "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
        this.assertFingerprintQueryCorrectness(node4.getId(), "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
        this.assertFingerprintQueryCorrectness(nodeMetaData4.getNodeRef().getId(), "*[count(//doc)= 4]", "//result/doc[1]/long[@name='DBID'][.='" + node1.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + node2.getId() + "']", "//result/doc[3]/long[@name='DBID'][.='" + node3.getId() + "']", "//result/doc[4]/long[@name='DBID'][.='" + node4.getId() + "']");
    }

    @Test
    public void testFingerprintStillExistsAfterNodeMetadataUpdate() throws Exception {
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 1);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, this.acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, this.acl, "mike", null, false);
        AlfrescoSolrFingerprintIT.indexTransaction(txn, Collections.singletonList(fileNode), Collections.singletonList(fileMetaData), Collections.singletonList("This is a text content which is longer than the default hello world " + fileNode.getId() + " returned by the Mock SOLRAPIQueueClient. This is needed because the \"min_hash\" field type definition in Solr doesn't take in account fields which produce less than 5 tokens (see the ShingleFilter settings)."));
        this.makeSureTransactionHasBeenIndexed(txn.getId());
        this.makeSureContentNodeHasBeenIndexed(fileNode, "mike", "world");
        this.assertFingerprintQueryCorrectness(fileNode.getId(), "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + fileNode.getId() + "']");
        fileMetaData.setOwner("Andrea");
        fileMetaData.getProperties().put(ContentModel.PROP_TITLE, new StringPropertyValue("This is the new file \"title\" metadata attribute."));
        AlfrescoSolrFingerprintIT.reindexTransactionId(txn.getId());
        this.makeSureContentNodeHasBeenIndexed(fileNode, "Andrea", "world");
        this.assertFingerprintQueryCorrectness(fileNode.getId(), "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + fileNode.getId() + "']");
    }

    private void makeSureContentNodeHasBeenIndexed(Node node, String owner, String testTerm) throws Exception {
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), 1L, MAX_WAIT_TIME);
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(node.getId()))), 1L, MAX_WAIT_TIME);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", owner)), BooleanClause.Occur.MUST));
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)builder.build(), 1L, MAX_WAIT_TIME);
    }

    private void makeSureContentNodesHaveBeenIndexed(String owner, String testTerm, int expectedCount) throws Exception {
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), expectedCount, MAX_WAIT_TIME);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", testTerm)), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", owner)), BooleanClause.Occur.MUST));
        AlfrescoSolrFingerprintIT.waitForDocCount((Query)builder.build(), expectedCount, MAX_WAIT_TIME);
    }

    private void assertFingerprintQueryCorrectness(long id, String ... assertions) {
        this.assertFingerprintQueryCorrectness(String.valueOf(id), assertions);
    }

    private void assertFingerprintQueryCorrectness(String id, String ... assertions) {
        ModifiableSolrParams params = new ModifiableSolrParams().add("q", new String[]{"FINGERPRINT:" + id}).add("qt", new String[]{"/afts"}).add("start", new String[]{"0"}).add("rows", new String[]{"6"}).add("sort", new String[]{"id asc"});
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"joel\"], \"tenants\": [ \"\" ]}");
        AlfrescoSolrFingerprintIT.assertQ((SolrQueryRequest)req, assertions);
    }

    private List<String> randomTextContent() {
        int[] sizes = new int[]{2000, 1000, 1500, 750};
        return Arrays.stream(sizes).mapToObj(item -> {
            Random randomizer = new Random(1L);
            return IntStream.range(0, item).mapToObj(i -> randomizer.nextInt()).map(Object::toString).collect(Collectors.joining(" "));
        }).collect(Collectors.toList());
    }
}

