/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.security;

import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.security.SecretSharedPropertyCollector;
import org.alfresco.solr.security.SecretSharedPropertyHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SecretSharedPropertyCollectorTest {
    private static final String A_COMMS_METHOD = "aCommsMethod";
    private static final String SET_THROUGH_SYSTEM_PROPERTY = "aCommsMethod_SetThroughSystemProperty";
    private static final String SET_THROUGH_ALFRESCO_COMMON_CONFIG = "aCommsMethod_SetThroughAlfrescoCommonConfig";
    private static final String COMMS_METHOD_FROM_SOLRCORE = "aCommsMethod_FromSolrCore";
    private static final String SECRET_VALUE = "my-secret";
    private static final String SECURE_COMMS_NONE = "none";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final Set<String> PROPS_TO_CLEAR = Set.of("alfresco.secureComms.secret", "alfresco.secureComms", "alfresco.allowUnauthenticatedSolrEndpoint");

    @Before
    public void setUp() {
        SecretSharedPropertyCollector.PROPS_CACHE.clear();
        for (String property : PROPS_TO_CLEAR) {
            Assert.assertNull((Object)System.getProperty(property));
            Assert.assertNull((Object)AlfrescoSolrDataModel.getCommonConfig().getProperty(property));
        }
    }

    @After
    public void tearDown() {
        for (String property : PROPS_TO_CLEAR) {
            System.clearProperty(property);
            AlfrescoSolrDataModel.getCommonConfig().remove(property);
        }
    }

    @Test
    public void getSecret_shouldReturnTheSecretValue() {
        System.setProperty("alfresco.secureComms.secret", SECRET_VALUE);
        Assert.assertEquals((Object)SECRET_VALUE, (Object)SecretSharedPropertyCollector.getSecret());
    }

    @Test(expected=RuntimeException.class)
    public void getSecretWithMissingSecretValue_shouldThrowException() {
        SecretSharedPropertyCollector.getSecret();
    }

    @Test
    public void allowUnauthenticatedSolrIsNotSet_shouldReturnFalse() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.allowUnauthenticatedSolrEndpoint", (String)FALSE)).thenReturn(Collections.emptySet());
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
        }
    }

    @Test
    public void allowUnauthenticatedSolrIsTrueThroughSystemProperty_shouldReturnTrue() {
        System.setProperty("alfresco.allowUnauthenticatedSolrEndpoint", TRUE);
        Assert.assertTrue((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
    }

    @Test
    public void allowUnauthenticatedSolrIsFalseThroughSystemProperty_shouldReturnFalse() {
        System.setProperty("alfresco.allowUnauthenticatedSolrEndpoint", FALSE);
        Assert.assertFalse((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
    }

    @Test
    public void allowUnauthenticatedSolrIsTrueThroughAlfrescoProperties_shouldReturnTrue() {
        try (MockedStatic mock = Mockito.mockStatic(AlfrescoSolrDataModel.class);){
            Properties alfrescoCommonConfig = new Properties();
            alfrescoCommonConfig.setProperty("alfresco.allowUnauthenticatedSolrEndpoint", TRUE);
            mock.when(AlfrescoSolrDataModel::getCommonConfig).thenReturn((Object)alfrescoCommonConfig);
            Assert.assertTrue((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
        }
    }

    @Test
    public void allowUnauthenticatedSolrIsFalseThroughAlfrescoProperties_shouldReturnFalse() {
        try (MockedStatic mock = Mockito.mockStatic(AlfrescoSolrDataModel.class);){
            Properties alfrescoCommonConfig = new Properties();
            alfrescoCommonConfig.setProperty("alfresco.allowUnauthenticatedSolrEndpoint", FALSE);
            mock.when(AlfrescoSolrDataModel::getCommonConfig).thenReturn((Object)alfrescoCommonConfig);
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
        }
    }

    @Test
    public void allowUnauthenticatedSolrIsTrueThroughSolrCores_shouldReturnTrue() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.allowUnauthenticatedSolrEndpoint", (String)FALSE)).thenReturn(Set.of(TRUE));
            Assert.assertTrue((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
        }
    }

    @Test
    public void allowUnauthenticatedSolrIsFalseThroughSolrCores_shouldReturnFalse() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.allowUnauthenticatedSolrEndpoint", (String)FALSE)).thenReturn(Set.of(FALSE));
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint());
        }
    }

    @Test
    public void commsMethodIsNotNull_shouldReturnThatValue() {
        SecretSharedPropertyCollector.PROPS_CACHE.put("alfresco.secureComms", A_COMMS_METHOD);
        Assert.assertEquals((Object)A_COMMS_METHOD, (Object)SecretSharedPropertyCollector.getCommsMethod());
        Assert.assertFalse((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
    }

    @Test
    public void commsMethodIsNotNullAndIsSecret_shouldReturnThatValue() {
        SecretSharedPropertyCollector.PROPS_CACHE.put("alfresco.secureComms", "secret");
        Assert.assertEquals((Object)"secret", (Object)SecretSharedPropertyCollector.getCommsMethod());
        Assert.assertTrue((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
    }

    @Test
    public void commsMethodThroughSystemProperty() {
        System.setProperty("alfresco.secureComms", SET_THROUGH_SYSTEM_PROPERTY);
        Assert.assertEquals((Object)SET_THROUGH_SYSTEM_PROPERTY, (Object)SecretSharedPropertyCollector.getCommsMethod());
        Assert.assertFalse((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
    }

    @Test
    public void commsMethodSetToSecretThroughSystemProperty() {
        System.setProperty("alfresco.secureComms", "secret");
        Assert.assertEquals((Object)"secret", (Object)SecretSharedPropertyCollector.getCommsMethod());
        Assert.assertTrue((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
    }

    @Test
    public void commsMethodThroughAlfrescoProperties() {
        try (MockedStatic mock = Mockito.mockStatic(AlfrescoSolrDataModel.class);){
            Properties alfrescoCommonConfig = new Properties();
            alfrescoCommonConfig.setProperty("alfresco.secureComms", SET_THROUGH_ALFRESCO_COMMON_CONFIG);
            mock.when(AlfrescoSolrDataModel::getCommonConfig).thenReturn((Object)alfrescoCommonConfig);
            Assert.assertEquals((Object)SET_THROUGH_ALFRESCO_COMMON_CONFIG, (Object)SecretSharedPropertyCollector.getCommsMethod());
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
        }
    }

    @Test
    public void commsMethodThroughSolrCores() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.secureComms", (String)SECURE_COMMS_NONE)).thenReturn(Set.of(COMMS_METHOD_FROM_SOLRCORE));
            Assert.assertEquals((Object)COMMS_METHOD_FROM_SOLRCORE, (Object)SecretSharedPropertyCollector.getCommsMethod());
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
        }
    }

    @Test
    public void commsMethodThroughSolrCoresReturnEmptySet() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.secureComms", (String)SECURE_COMMS_NONE)).thenReturn(Collections.emptySet());
            Assert.assertNull((Object)SecretSharedPropertyCollector.getCommsMethod());
            Assert.assertFalse((boolean)SecretSharedPropertyCollector.isCommsSecretShared());
        }
    }

    @Test(expected=RuntimeException.class)
    public void commsMethodThroughSolrCoresReturnsMoreThanOneValue() {
        try (MockedStatic mock = Mockito.mockStatic(SecretSharedPropertyHelper.class);){
            mock.when(() -> SecretSharedPropertyHelper.getPropertyFromCores((String)"alfresco.secureComms", (String)SECURE_COMMS_NONE)).thenReturn(Set.of(COMMS_METHOD_FROM_SOLRCORE, "secret"));
            SecretSharedPropertyCollector.getCommsMethod();
        }
    }
}

