/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AclTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AclTrackerTest {
    @InjectMocks
    private AclTracker aclTracker;
    @Mock
    private SOLRAPIClient repositoryClient;
    @Mock
    private InformationServer solrInformationServer;

    @Before
    public void setUp() {
        this.aclTracker = new AclTracker();
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void testCheckRepoAndIndexConsistency_firstRun_success() throws Exception {
        TrackerState trackerState = new TrackerState();
        AclChangeSets firstChangeSets = new AclChangeSets(Collections.emptyList());
        Mockito.when((Object)this.repositoryClient.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)firstChangeSets);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
        Assert.assertTrue((String)"Expected first ACL transaction to have been checked.", (boolean)trackerState.isCheckedFirstAclTransactionTime());
        Assert.assertTrue((String)"Expected last ACL transaction to have been checked.", (boolean)trackerState.isCheckedLastAclTransactionTime());
    }

    @Test
    public void testCheckRepoAndIndexConsistency_alreadyInitialised_success() throws Exception {
        TrackerState trackerState = new TrackerState();
        trackerState.setLastGoodChangeSetCommitTimeInIndex(8000L);
        trackerState.setCheckedFirstAclTransactionTime(true);
        trackerState.setCheckedLastAclTransactionTime(true);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.repositoryClient, this.solrInformationServer});
    }

    @Test
    public void testCheckRepoAndIndexConsistency_populatedRepoEmptyIndex_success() throws Exception {
        TrackerState trackerState = new TrackerState();
        AclChangeSets firstChangeSets = new AclChangeSets(Arrays.asList(new AclChangeSet(1L, 1000L, 2)), Long.valueOf(8000L), Long.valueOf(8L));
        Mockito.when((Object)this.repositoryClient.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)firstChangeSets);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
        Assert.assertTrue((String)"Expected first ACL transaction to have been checked.", (boolean)trackerState.isCheckedFirstAclTransactionTime());
        Assert.assertTrue((String)"Expected last ACL transaction to have been checked.", (boolean)trackerState.isCheckedLastAclTransactionTime());
        Assert.assertEquals((String)"Expected last good change set commit time to be loaded from repository.", (long)trackerState.getLastGoodChangeSetCommitTimeInIndex(), (long)1000L);
        Assert.assertEquals((String)"Expected last change set commit time to be loaded from repository.", (long)trackerState.getLastChangeSetCommitTimeOnServer(), (long)1000L);
        Assert.assertEquals((String)"Expected last change set id to be loaded from repository.", (long)trackerState.getLastChangeSetIdOnServer(), (long)1L);
    }

    @Test
    public void testCheckRepoAndIndexConsistency_afterRestart_success() throws Exception {
        TrackerState trackerState = new TrackerState();
        trackerState.setLastGoodChangeSetCommitTimeInIndex(8000L);
        AclChangeSets firstChangeSets = new AclChangeSets(Arrays.asList(new AclChangeSet(1L, 1000L, 2)), Long.valueOf(8000L), Long.valueOf(8L));
        Mockito.when((Object)this.repositoryClient.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)firstChangeSets);
        Mockito.when((Object)this.solrInformationServer.getAclTxDocsSize("1", "1000")).thenReturn((Object)1);
        AclChangeSet lastIndexedChangeSet = new AclChangeSet(7L, 7000L, 7);
        Mockito.when((Object)this.solrInformationServer.getMaxAclChangeSetIdAndCommitTimeInIndex()).thenReturn((Object)lastIndexedChangeSet);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
        Assert.assertTrue((String)"Expected first ACL transaction to have been checked.", (boolean)trackerState.isCheckedFirstAclTransactionTime());
        Assert.assertTrue((String)"Expected last ACL transaction to have been checked.", (boolean)trackerState.isCheckedLastAclTransactionTime());
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testCheckRepoAndIndexConsistency_indexMissingFirstACLTx_runtimeException() throws Exception {
        TrackerState trackerState = new TrackerState();
        trackerState.setLastGoodChangeSetCommitTimeInIndex(8000L);
        AclChangeSets firstChangeSets = new AclChangeSets(Arrays.asList(new AclChangeSet(1L, 1000L, 2)), Long.valueOf(8000L), Long.valueOf(8L));
        Mockito.when((Object)this.repositoryClient.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)firstChangeSets);
        Mockito.when((Object)this.solrInformationServer.getAclTxDocsSize("1", "1000")).thenReturn((Object)0);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testCheckRepoAndIndexConsistency_indexAheadOfRepo_runtimeException() throws Exception {
        TrackerState trackerState = new TrackerState();
        trackerState.setLastGoodChangeSetCommitTimeInIndex(8000L);
        AclChangeSets firstChangeSets = new AclChangeSets(Arrays.asList(new AclChangeSet(1L, 1000L, 2)), Long.valueOf(8000L), Long.valueOf(8L));
        Mockito.when((Object)this.repositoryClient.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1)).thenReturn((Object)firstChangeSets);
        Mockito.when((Object)this.solrInformationServer.getAclTxDocsSize("1", "1000")).thenReturn((Object)1);
        AclChangeSet lastIndexedChangeSet = new AclChangeSet(9L, 9000L, 9);
        Mockito.when((Object)this.solrInformationServer.getMaxAclChangeSetIdAndCommitTimeInIndex()).thenReturn((Object)lastIndexedChangeSet);
        this.aclTracker.checkRepoAndIndexConsistency(trackerState);
    }
}

