/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedContentPropertiesIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        Properties solrCoreProperties = DEFAULT_CORE_PROPS;
        solrCoreProperties.setProperty("solr.enableIndexingCustomContent", "true");
        DistributedContentPropertiesIT.initSolrServers(3, DistributedContentPropertiesIT.class.getSimpleName(), solrCoreProperties);
    }

    @After
    public void clearData() throws Exception {
        DistributedContentPropertiesIT.deleteByQueryAllClients("*:*");
        DistributedContentPropertiesIT.explicitCommitOnAllClients();
    }

    @AfterClass
    public static void destroyData() {
        DistributedContentPropertiesIT.dismissSolrServers();
    }

    @Test
    public void eachNodeHasAtMaximumOneCmContentField() throws Exception {
        DistributedContentPropertiesIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int howManyTestNodes = 10;
        Transaction transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        List<Node> nodes = this.nodes(howManyTestNodes, transaction, acl);
        List<NodeMetaData> metadata = this.metadata(nodes, transaction, acl);
        int howManyNodesWithContent = howManyTestNodes - 3;
        DistributedContentPropertiesIT.indexTransaction(transaction, nodes, metadata, this.textContent(nodes, "Lorem ipsum dolor sit amet", howManyNodesWithContent));
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "ipsum")), howManyNodesWithContent, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "ipsum")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    @Test
    public void eachNodeHasAtMaximumOneCustomContentField() throws Exception {
        DistributedContentPropertiesIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int howManyTestNodes = 10;
        Transaction transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        List<Node> nodes = this.nodes(howManyTestNodes, transaction, acl);
        List<NodeMetaData> metadata = this.metadata(nodes, transaction, acl).stream().peek(nodeMetadata -> {
            nodeMetadata.getProperties().remove(ContentModel.PROP_CONTENT);
            nodeMetadata.getProperties().put(ContentModel.PROP_PERSONDESC, new ContentPropertyValue(Locale.US, 0L, "UTF-8", "text/plain", null));
        }).collect(Collectors.toList());
        int howManyNodesWithContent = howManyTestNodes - 4;
        int howManyNodesWithoutContent = howManyTestNodes - howManyNodesWithContent;
        List<Map<QName, String>> textContents = Stream.concat(IntStream.range(0, howManyNodesWithContent).mapToObj(index -> Map.of(ContentModel.PROP_PERSONDESC, "consectetur Adipiscing elit " + System.currentTimeMillis())), IntStream.range(0, howManyNodesWithoutContent).mapToObj(index -> Map.of(ContentModel.PROP_PERSONDESC, ""))).collect(Collectors.toList());
        DistributedContentPropertiesIT.indexTransactionWithMultipleContentFields(transaction, nodes, metadata, textContents);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "adipiscing")), howManyNodesWithContent, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "adipiscing")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    @Test
    public void eachNodeHasOneCustomAndOneDefaultContentField() throws Exception {
        DistributedContentPropertiesIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int howManyTestNodes = 10;
        Transaction transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        List<Node> nodes = this.nodes(howManyTestNodes, transaction, acl);
        List<NodeMetaData> metadata = this.metadata(nodes, transaction, acl).stream().peek(nodeMetadata -> nodeMetadata.getProperties().put(ContentModel.PROP_PERSONDESC, new ContentPropertyValue(Locale.US, 0L, "UTF-8", "text/plain", null))).collect(Collectors.toList());
        int howManyNodesWithContent = howManyTestNodes - 2;
        DistributedContentPropertiesIT.indexTransactionWithMultipleContentFields(transaction, nodes, metadata, this.textContentWithMultipleContentFields(nodes, "Lorem ipsum dolor sit amet", "consectetur Adipiscing elit", howManyNodesWithContent));
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "consectetur")), howManyNodesWithContent, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "ipsum")), howManyNodesWithContent, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "ipsum")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "elit")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    @Test
    public void someNodeHasOneCustomAndSomeNodeHasOneDefaultContentField() throws Exception {
        DistributedContentPropertiesIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int howManyTestNodes = 10;
        Transaction transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        List<Node> nodes = this.nodes(howManyTestNodes, transaction, acl);
        List<NodeMetaData> metadata = this.metadata(nodes, transaction, acl).stream().peek(nodeMetadata -> nodeMetadata.getProperties().put(ContentModel.PROP_PERSONDESC, new ContentPropertyValue(Locale.US, 0L, "UTF-8", "text/plain", null))).collect(Collectors.toList());
        int howManyNodesWithContent = howManyTestNodes - 2;
        int howManyNodesWithDefaultContentField = 3;
        int howManyNodesWithCustomContentField = howManyNodesWithContent - howManyNodesWithDefaultContentField;
        int howManyNodesWithoutContent = howManyTestNodes - howManyNodesWithContent;
        String baseCmContentText = "Lorem ipsum dolor sit amet";
        String basePersonDescriptionText = "consectetur Adipiscing elit";
        Stream<Map> texts = Stream.concat(IntStream.range(0, howManyNodesWithDefaultContentField).mapToObj(index -> Map.of(ContentModel.PROP_CONTENT, baseCmContentText + " " + System.currentTimeMillis(), ContentModel.PROP_PERSONDESC, "")), IntStream.range(0, howManyNodesWithCustomContentField).mapToObj(index -> Map.of(ContentModel.PROP_CONTENT, "", ContentModel.PROP_PERSONDESC, basePersonDescriptionText + " " + System.currentTimeMillis())));
        List<Map<QName, String>> textContents = Stream.concat(texts, IntStream.range(0, howManyNodesWithoutContent).mapToObj(index -> Map.of(ContentModel.PROP_CONTENT, "", ContentModel.PROP_PERSONDESC, ""))).collect(Collectors.toList());
        DistributedContentPropertiesIT.indexTransactionWithMultipleContentFields(transaction, nodes, metadata, textContents);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "consectetur")), howManyNodesWithCustomContentField, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "ipsum")), howManyNodesWithDefaultContentField, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "ipsum")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "elit")), 0, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }

    @Test
    public void testMNT23669() throws Exception {
        DistributedContentPropertiesIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, 1L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int howManyTestNodes = 2;
        Transaction transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        List<Node> nodes = this.nodes(howManyTestNodes, transaction, acl);
        List<NodeMetaData> metadata = this.metadata(nodes, transaction, acl).stream().peek(nodeMetadata -> nodeMetadata.getProperties().put(ContentModel.PROP_PERSONDESC, new ContentPropertyValue(Locale.US, 0L, "UTF-8", "text/plain", null))).collect(Collectors.toList());
        int howManyNodesWithContent = howManyTestNodes;
        String baseCmContentText = "Test default content property";
        String basePersonDescriptionText = "custom content property text";
        DistributedContentPropertiesIT.indexTransactionWithMultipleContentFields(transaction, nodes, metadata, this.textContentWithMultipleContentFields(nodes, baseCmContentText, basePersonDescriptionText, howManyNodesWithContent));
        DistributedContentPropertiesIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "custom")), howManyNodesWithContent, AlfrescoSolrUtils.MAX_WAIT_TIME);
        transaction = AlfrescoSolrUtils.getTransaction(0, howManyTestNodes);
        for (Node node : nodes) {
            node.setTxnId(transaction.getId());
        }
        basePersonDescriptionText = "changing value for person description";
        DistributedContentPropertiesIT.indexTransactionWithMultipleContentFields(transaction, nodes, metadata, this.textContentWithMultipleContentFields(nodes, baseCmContentText, basePersonDescriptionText, howManyNodesWithContent));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        BooleanQuery.Builder customContentBuilder = new BooleanQuery.Builder();
        TermQuery oldValueQuery = new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "custom"));
        TermQuery newValueQuery = new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}" + ContentModel.PROP_PERSONDESC.getLocalName(), "changing"));
        customContentBuilder.add(new BooleanClause((Query)oldValueQuery, BooleanClause.Occur.SHOULD));
        customContentBuilder.add(new BooleanClause((Query)newValueQuery, BooleanClause.Occur.SHOULD));
        builder.add(new BooleanClause((Query)customContentBuilder.build(), BooleanClause.Occur.MUST));
        SolrClient client = DistributedContentPropertiesIT.getStandaloneClients().get(0);
        int totalHits = 0;
        for (int i = 0; i < 15; ++i) {
            QueryResponse response = client.query((SolrParams)DistributedContentPropertiesIT.luceneToSolrQuery((Query)builder.build()));
            totalHits = (int)response.getResults().getNumFound();
            if (totalHits != howManyNodesWithContent) {
                DistributedContentPropertiesIT.fail((String)("(" + i + ") Expecting " + howManyNodesWithContent + " results but " + totalHits + " have been returned"));
            }
            Thread.sleep(1000L);
        }
    }

    private List<Node> nodes(int howMany, Transaction transaction, Acl acl) {
        return IntStream.range(0, howMany).mapToObj(index -> AlfrescoSolrUtils.getNode(transaction, acl, Node.SolrApiNodeStatus.UPDATED)).collect(Collectors.toList());
    }

    private List<NodeMetaData> metadata(List<Node> nodes, Transaction transaction, Acl acl) {
        return nodes.stream().map(node -> AlfrescoSolrUtils.getNodeMetaData(node, transaction, acl, "mike", null, false)).collect(Collectors.toList());
    }

    private List<String> textContent(List<Node> nodes, String baseText, int limit) {
        return Stream.concat(nodes.stream().map(node -> baseText + " " + System.currentTimeMillis()).limit(limit), IntStream.range(0, nodes.size() - limit).mapToObj(index -> "")).collect(Collectors.toList());
    }

    private List<Map<QName, String>> textContentWithMultipleContentFields(List<Node> nodes, String baseCmContentText, String basePersonDescriptionText, int limit) {
        Stream<Map> texts = nodes.stream().map(node -> Map.of(ContentModel.PROP_CONTENT, baseCmContentText + " " + System.currentTimeMillis(), ContentModel.PROP_PERSONDESC, basePersonDescriptionText + " " + System.currentTimeMillis())).limit(limit);
        return Stream.concat(texts, IntStream.range(0, nodes.size() - limit).mapToObj(index -> Map.of(ContentModel.PROP_CONTENT, "", ContentModel.PROP_PERSONDESC, ""))).collect(Collectors.toList());
    }
}

