/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.SolrTrackerScheduler;
import org.alfresco.solr.tracker.Tracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class SolrTrackerSchedulerTest {
    @Mock
    private AlfrescoCoreAdminHandler adminHandler;
    private SolrTrackerScheduler trackerScheduler;
    private String CORE_NAME = "coreName";
    private Scheduler spiedQuartzScheduler;
    @Mock
    SOLRAPIClient client;
    String coreName = "alfresco";
    @Mock
    InformationServer informationServer;
    Properties props;

    @Before
    public void setUp() throws Exception {
        this.trackerScheduler = new SolrTrackerScheduler(this.adminHandler);
        this.trackerScheduler.scheduler = this.spiedQuartzScheduler = (Scheduler)Mockito.spy((Object)this.trackerScheduler.scheduler);
        this.props = new Properties();
        this.props.put("alfresco.stores", "workspace://SpacesStore");
        this.props.put("alfresco.batch.count", "5000");
        this.props.put("alfresco.maxLiveSearchers", "2");
        this.props.put("shard.count", "1");
        this.props.put("shard.instance", "0");
        this.props.put("shard.method", "SHARD_METHOD_DBID");
        this.props.put("alfresco.template", "");
        this.props.put("alfresco.index.transformContent", "true");
    }

    @After
    public void tearDown() throws Exception {
        if (this.trackerScheduler != null && !this.trackerScheduler.isShutdown()) {
            this.trackerScheduler.shutdown();
        }
    }

    @Test
    public void testAclSchedule() throws SchedulerException {
        String exp = "0/12 * * * * ? *";
        this.props.put("alfresco.acl.tracker.cron", exp);
        AclTracker aclTracker = new AclTracker(this.props, this.client, this.coreName, this.informationServer);
        this.trackerScheduler.schedule((Tracker)aclTracker, this.CORE_NAME, this.props);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.any(Trigger.class));
        this.checkCronExpression(exp);
    }

    @Test
    public void testContentTrackerSchedule() throws SchedulerException {
        String exp = "0/5 * * * * ? *";
        this.props.put("alfresco.content.tracker.cron", exp);
        ContentTracker contentTracker = new ContentTracker(this.props, this.client, this.coreName, this.informationServer);
        this.trackerScheduler.schedule((Tracker)contentTracker, this.CORE_NAME, this.props);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.any(Trigger.class));
        this.checkCronExpression(exp);
    }

    private void checkCronExpression(String exp) throws SchedulerException {
        for (JobKey jobKey : this.trackerScheduler.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"Solr"))) {
            List triggers = this.trackerScheduler.scheduler.getTriggersOfJob(jobKey);
            CronTrigger t = (CronTrigger)triggers.get(0);
            String cronExp = t.getCronExpression();
            Assert.assertEquals((Object)exp, (Object)cronExp);
        }
    }

    @Test
    public void testMetaDataTrackerSchedule() throws SchedulerException {
        String exp = "0/4 * * * * ? *";
        this.props.put("alfresco.metadata.tracker.cron", exp);
        MetadataTracker metadataTracker = new MetadataTracker(this.props, this.client, exp, this.informationServer);
        this.trackerScheduler.schedule((Tracker)metadataTracker, this.CORE_NAME, this.props);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.any(Trigger.class));
        this.checkCronExpression(exp);
    }

    @Test
    public void testSchedule() throws SchedulerException {
        String exp = "0/1 * * * * ? *";
        this.props.put("alfresco.cascade.tracker.cron", exp);
        CascadeTracker cascadeTracker = new CascadeTracker(this.props, this.client, exp, this.informationServer);
        this.trackerScheduler.schedule((Tracker)cascadeTracker, this.CORE_NAME, this.props);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.any(Trigger.class));
        this.checkCronExpression(exp);
    }

    @Test
    public void testShutdown() throws SchedulerException {
        this.trackerScheduler.shutdown();
        Assert.assertTrue((boolean)this.trackerScheduler.isShutdown());
    }

    @Test
    public void testDeleteTrackerJobs() throws SchedulerException {
        ContentTracker contentTracker = new ContentTracker();
        MetadataTracker metadataTracker = new MetadataTracker();
        AclTracker aclTracker = new AclTracker();
        this.trackerScheduler.deleteTrackerJobs(this.CORE_NAME, Arrays.asList(contentTracker, metadataTracker, aclTracker));
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler, (VerificationMode)Mockito.times((int)3))).deleteJob((JobKey)ArgumentMatchers.any(JobKey.class));
    }

    @Test
    public void testDeleteTrackerJob() throws SchedulerException {
        ModelTracker modelTracker = new ModelTracker();
        this.trackerScheduler.deleteTrackerJob(this.CORE_NAME, (Tracker)modelTracker);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).deleteJob((JobKey)ArgumentMatchers.any(JobKey.class));
    }

    @Test
    public void testDeleteTrackerInstanceJob() throws SchedulerException {
        CascadeTracker cascadeTracker = new CascadeTracker(this.props, this.client, this.coreName, this.informationServer);
        CascadeTracker cascadeTracker2 = new CascadeTracker(this.props, this.client, this.coreName, this.informationServer);
        this.trackerScheduler.schedule((Tracker)cascadeTracker, this.CORE_NAME, this.props);
        this.trackerScheduler.deleteJobForTrackerInstance(this.CORE_NAME, (Tracker)cascadeTracker2);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler, (VerificationMode)Mockito.never())).deleteJob((JobKey)ArgumentMatchers.any(JobKey.class));
        this.trackerScheduler.deleteJobForTrackerInstance(this.CORE_NAME, (Tracker)cascadeTracker);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler, (VerificationMode)Mockito.times((int)1))).deleteJob((JobKey)ArgumentMatchers.any(JobKey.class));
    }

    @Test
    public void newSchedulerIsNotShutdown() throws SchedulerException {
        Assert.assertFalse((boolean)this.trackerScheduler.isShutdown());
    }

    @Test
    public void testPauseAll() throws SchedulerException {
        this.trackerScheduler.pauseAll();
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).pauseAll();
    }

    @Test
    public void testModeltTrackerSchedule() throws SchedulerException {
        String exp = "0/20 * * * * ? *";
        this.props.put("alfresco.model.tracker.cron", exp);
        ModelTracker modelTracker = new ModelTracker("alfresco", this.props, this.client, this.CORE_NAME, this.informationServer);
        this.trackerScheduler.schedule((Tracker)modelTracker, this.CORE_NAME, this.props);
        ((Scheduler)Mockito.verify((Object)this.spiedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.any(Trigger.class));
        this.checkCronExpression(exp);
    }
}

