/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AlfrescoSearchHandler;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AlfrescoSearchHandlerFacetQueryIT {
    @Mock
    NamedList<NamedList<Object>> mockParams;
    @Mock
    SolrQueryResponse mockResponse;
    @Mock
    SolrQueryRequest mockRequest;
    @Mock
    BasicResultContext mockResultContext;
    @Mock
    FacetComponent.FacetContext mockFacetContext;
    @Mock
    Map<Object, Object> mockContext;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResponse.getValues()).thenReturn(this.mockParams);
        Mockito.when((Object)this.mockResponse.getResponse()).thenReturn((Object)this.mockResultContext);
        Mockito.when((Object)this.mockResultContext.getRequest()).thenReturn((Object)this.mockRequest);
        Mockito.when((Object)this.mockRequest.getContext()).thenReturn(this.mockContext);
        Mockito.when((Object)this.mockContext.get("_facet.context")).thenReturn((Object)this.mockFacetContext);
    }

    @Test
    public void testKeysWithCountZeroAreRemoved() {
        NamedList facetQueries = new NamedList();
        facetQueries.add("small", (Object)1);
        facetQueries.add("medium", (Object)0);
        facetQueries.add("big", (Object)0);
        NamedList facetCounts = new NamedList();
        facetCounts.add("facet_queries", (Object)facetQueries);
        Mockito.when((Object)((NamedList)this.mockParams.get("facet_counts"))).thenReturn((Object)facetCounts);
        ArrayList queryFacets = new ArrayList();
        Mockito.when((Object)this.mockFacetContext.getAllQueryFacets()).thenReturn(queryFacets);
        AlfrescoSearchHandler.removeFacetQueriesWithCountZero((SolrQueryResponse)this.mockResponse);
        Assert.assertEquals((long)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).get("facet_queries")).size(), (long)1L);
        Assert.assertEquals((Object)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).getVal(0)).get("small"), (Object)1);
    }

    @Test
    public void testKeysWithCountNonZeroArePresent() {
        NamedList facetQueries = new NamedList();
        facetQueries.add("small", (Object)1);
        facetQueries.add("medium", (Object)2);
        facetQueries.add("big", (Object)10);
        NamedList facetCounts = new NamedList();
        facetCounts.add("facet_queries", (Object)facetQueries);
        Mockito.when((Object)((NamedList)this.mockParams.get("facet_counts"))).thenReturn((Object)facetCounts);
        ArrayList queryFacets = new ArrayList();
        Mockito.when((Object)this.mockFacetContext.getAllQueryFacets()).thenReturn(queryFacets);
        AlfrescoSearchHandler.removeFacetQueriesWithCountZero((SolrQueryResponse)this.mockResponse);
        Assert.assertEquals((long)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).get("facet_queries")).size(), (long)3L);
        Assert.assertEquals((Object)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).getVal(0)).get("small"), (Object)1);
        Assert.assertEquals((Object)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).getVal(0)).get("medium"), (Object)2);
        Assert.assertEquals((Object)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).getVal(0)).get("big"), (Object)10);
    }

    @Test
    public void testEmptyFacetQueries() {
        NamedList facetQueries = new NamedList();
        NamedList facetCounts = new NamedList();
        facetCounts.add("facet_queries", (Object)facetQueries);
        Mockito.when((Object)((NamedList)this.mockParams.get("facet_counts"))).thenReturn((Object)facetCounts);
        ArrayList queryFacets = new ArrayList();
        Mockito.when((Object)this.mockFacetContext.getAllQueryFacets()).thenReturn(queryFacets);
        AlfrescoSearchHandler.removeFacetQueriesWithCountZero((SolrQueryResponse)this.mockResponse);
        Assert.assertEquals((long)((NamedList)((NamedList)this.mockResponse.getValues().get("facet_counts")).get("facet_queries")).size(), (long)0L);
    }

    @Test
    public void testEmptyFacetCount() {
        NamedList facetCounts = new NamedList();
        Mockito.when((Object)((NamedList)this.mockParams.get("facet_counts"))).thenReturn((Object)facetCounts);
        ArrayList queryFacets = new ArrayList();
        Mockito.when((Object)this.mockFacetContext.getAllQueryFacets()).thenReturn(queryFacets);
        AlfrescoSearchHandler.removeFacetQueriesWithCountZero((SolrQueryResponse)this.mockResponse);
        Assert.assertEquals((long)((NamedList)this.mockResponse.getValues().get("facet_counts")).size(), (long)0L);
    }
}

