/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;

public class HandlerOfResources {
    protected static final List<String> DISALLOWED_SHARED_UPDATES = Arrays.asList("alfresco.identifier.property.", "alfresco.suggestable.property.", "alfresco.cross.locale.property.", "alfresco.cross.locale.datatype.");

    public static InputStream openResource(String solrHome, String resource) {
        InputStream is = null;
        try {
            File f0;
            File f = f0 = new File(resource);
            if (!f.isAbsolute()) {
                Object path = solrHome;
                path = ((String)path).endsWith("/") ? path : (String)path + "/";
                f = new File((String)path + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            if (f != f0 && f0.isFile() && f0.canRead()) {
                return new FileInputStream(f0);
            }
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new RuntimeException("Can't find resource '" + resource + "' in classpath or '" + solrHome + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public static void updateSharedProperties(SolrParams params, File config, boolean disallow) throws IOException {
        List<String> disallowed = disallow ? DISALLOWED_SHARED_UPDATES : Collections.emptyList();
        try {
            HandlerOfResources.updatePropertiesFile(params, config, disallowed);
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "For shared properties you are not allowed to update any of the following " + String.valueOf(DISALLOWED_SHARED_UPDATES));
        }
    }

    public static void updatePropertiesFile(SolrParams params, File config, List<String> disallowed) {
        Properties properties = new Properties();
        Properties extraProperties = HandlerOfResources.extractCustomProperties(params);
        try (FileInputStream configFile = new FileInputStream(config);){
            properties.load(configFile);
            if (extraProperties != null && !extraProperties.isEmpty()) {
                if (!HandlerOfResources.allowedProperties(extraProperties, disallowed)) {
                    throw new IllegalArgumentException("You are not permitted to update these properties.");
                }
                properties.putAll((Map<?, ?>)extraProperties);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(config);){
                properties.store(fileOutputStream, "Generated from Solr");
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unabled to update properties file, " + e.getMessage());
        }
    }

    public static boolean allowedProperties(Properties toCheck, List<String> disallowed) {
        if (toCheck == null || toCheck.isEmpty() || disallowed == null || disallowed.isEmpty()) {
            return true;
        }
        for (Object key : toCheck.keySet()) {
            for (String prop : disallowed) {
                if (!key.toString().startsWith(prop)) continue;
                return false;
            }
        }
        return true;
    }

    public static Properties extractCustomProperties(SolrParams params) {
        Properties properties = new Properties();
        Iterator it = params.getParameterNamesIterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            if (!paramName.startsWith("property.")) continue;
            properties.setProperty(paramName.substring("property.".length()), params.get(paramName));
        }
        return properties;
    }

    public static boolean getSafeBoolean(SolrParams params, String paramName) {
        boolean paramValue = false;
        if (params.get(paramName) != null) {
            paramValue = Boolean.valueOf(params.get(paramName));
        }
        return paramValue;
    }

    public static Long getSafeLong(SolrParams params, String paramName) {
        Long paramValue = null;
        if (params.get(paramName) != null) {
            paramValue = Long.valueOf(params.get(paramName));
        }
        return paramValue;
    }
}

