/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.GUID;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryLoggingComponent
extends SearchComponent {
    public void finishStage(ResponseBuilder rb) {
        super.finishStage(rb);
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        try {
            this.log(rb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public void process(ResponseBuilder rb) throws IOException {
        this.log(rb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(ResponseBuilder rb) throws IOException {
        CoreContainer container;
        SolrCore logCore;
        boolean isShard = rb.req.getParams().getBool("isShard", false);
        if (!isShard && (logCore = (container = rb.req.getCore().getCoreContainer()).getCore(rb.req.getCore().getName() + "_qlog")) != null) {
            JSONObject json = (JSONObject)rb.req.getContext().get("ALFRESCO_JSON");
            LocalSolrQueryRequest request = null;
            UpdateRequestProcessor processor = null;
            try {
                request = new LocalSolrQueryRequest(logCore, new NamedList());
                processor = logCore.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, new SolrQueryResponse());
                AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
                cmd.overwrite = true;
                SolrInputDocument input = new SolrInputDocument(new String[0]);
                input.addField("id", (Object)GUID.generate());
                input.addField("_version_", (Object)"1");
                input.addField("timestamp", (Object)DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
                if (json != null) {
                    try {
                        ArrayList<String> authorityList = new ArrayList<String>(1);
                        JSONArray authorities = json.getJSONArray("authorities");
                        for (int i = 0; i < authorities.length(); ++i) {
                            String authorityString = authorities.getString(i);
                            authorityList.add(authorityString);
                        }
                        for (String authority : authorityList) {
                            if (AuthorityType.getAuthorityType((String)authority) != AuthorityType.USER) continue;
                            input.addField("user", (Object)authority);
                        }
                    }
                    catch (JSONException e) {
                        input.addField("user", (Object)"<UNKNOWN>");
                    }
                } else {
                    input.addField("user", (Object)"<UNKNOWN>");
                }
                String userQuery = rb.req.getParams().get("spellcheck.q");
                if (userQuery == null && json != null) {
                    try {
                        userQuery = json.getString("query");
                    }
                    catch (JSONException authorities) {
                        // empty catch block
                    }
                }
                if (userQuery == null) {
                    userQuery = rb.req.getParams().get("q");
                }
                if (userQuery != null) {
                    input.addField("user_query", (Object)userQuery);
                }
                Query query = rb.getQuery();
                input.addField("query", (Object)query.toString());
                if (rb.getResults().docList != null) {
                    input.addField("found", (Object)rb.getResults().docList.matches());
                }
                input.addField("time", (Object)rb.req.getRequestTimer().getTime());
                cmd.solrDoc = input;
                processor.processAdd(cmd);
            }
            finally {
                if (processor != null) {
                    processor.finish();
                }
                if (request != null) {
                    request.close();
                }
            }
        }
    }

    public String getDescription() {
        return null;
    }
}

