/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.SolrReturnFields;

public class RewriteFieldListComponent
extends SearchComponent {
    private boolean checkParamsHaveBeenRewritten(SolrParams params) {
        return params.get("originalFl") != null;
    }

    private void transformFieldList(SolrQueryRequest req) {
        HashSet<String> fieldListSet = new HashSet<String>();
        Set<String> defaultNonCachedFields = Set.of("id", "DBID");
        HashSet<String> allowedNonCachedFields = new HashSet<String>(defaultNonCachedFields);
        allowedNonCachedFields.add("score");
        SolrReturnFields solrReturnFields = new SolrReturnFields(req);
        String originalFieldList = req.getParams().get("fl");
        boolean cacheTransformer = Optional.ofNullable(solrReturnFields.getTransformer()).map(DocTransformer::getName).map(name -> name.contains("fmap")).orElse(false);
        ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
        if (!cacheTransformer) {
            if (!solrReturnFields.wantsAllFields()) {
                fieldListSet.addAll(solrReturnFields.getLuceneFieldNames().stream().filter(allowedNonCachedFields::contains).collect(Collectors.toSet()));
            }
            if (fieldListSet.isEmpty()) {
                fieldListSet.addAll(defaultNonCachedFields);
            }
            params.set("fl", new String[]{String.join((CharSequence)",", fieldListSet)});
        } else {
            if (solrReturnFields.wantsAllFields() || solrReturnFields.hasPatternMatching()) {
                fieldListSet.add("*");
            } else if (solrReturnFields.getLuceneFieldNames() != null) {
                fieldListSet.addAll(solrReturnFields.getLuceneFieldNames().stream().map(field -> AlfrescoSolrDataModel.getInstance().mapStoredProperty((String)field, req)).filter(Objects::nonNull).map(schemaFieldName -> schemaFieldName.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> Character.valueOf(Character.isJavaIdentifierPart(c.charValue()) ? (char)c.charValue() : (char)'?')).map(Object::toString).collect(Collectors.joining())).collect(Collectors.toSet()));
            }
            params.add("fl", new String[]{String.join((CharSequence)",", fieldListSet)});
        }
        params.set("originalFl", new String[]{originalFieldList});
        req.setParams((SolrParams)params);
    }

    public void prepare(ResponseBuilder responseBuilder) {
        SolrQueryRequest req = responseBuilder.req;
        if (this.checkParamsHaveBeenRewritten(req.getParams())) {
            return;
        }
        this.transformFieldList(req);
    }

    public void process(ResponseBuilder responseBuilder) {
    }

    public String getDescription() {
        return null;
    }
}

