/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.encryption.StringEncryptor;

public class PublicPrivateKeyShareStringEncryptor
implements StringEncryptor {
    static final int KEY_SIZE = 512;
    protected String keyAlgorithm = "RSA";
    protected String encryptionAlgorithm = "RSA/ECB/PKCS1PADDING";
    protected PrivateKey privateKey = null;
    protected PublicKey publicKey = null;
    static final String KEYNAME = "alfrescoSpringKey";
    static final String PUBKEYNAME = "alfrescoSpringKey.pub";
    static final String PRIKEYNAME = "alfrescoSpringKey.pri";
    static final String KEY_PACKAGE = "/alfresco/web-extension";
    static final String PRIKEYPATH = "/alfresco/web-extension/alfrescoSpringKey.pri";
    static final String PUBKEYPATH = "/alfresco/web-extension/alfrescoSpringKey.pub";

    @Override
    public String encrypt(String message) {
        byte[] cipherText = new byte[]{};
        String retval = message;
        if (this.publicKey == null) {
            return retval;
        }
        try {
            Cipher cipher = Cipher.getInstance(this.encryptionAlgorithm);
            cipher.init(1, this.publicKey);
            int chunkSize = 53;
            byte[] messageBytes = message.getBytes("UTF-8");
            if (messageBytes.length > chunkSize) {
                byte[] cipherChunk = new byte[]{};
                byte[] buffer = new byte[chunkSize];
                for (int i = 0; i < messageBytes.length; ++i) {
                    if (i > 0 && i % chunkSize == 0) {
                        cipherChunk = cipher.doFinal(buffer);
                        cipherText = PublicPrivateKeyShareStringEncryptor.append(cipherText, cipherChunk);
                        int newlength = chunkSize;
                        if (i + chunkSize > messageBytes.length) {
                            newlength = messageBytes.length - i;
                        }
                        buffer = new byte[newlength];
                    }
                    buffer[i % chunkSize] = messageBytes[i];
                }
                cipherChunk = cipher.doFinal(buffer);
                cipherText = PublicPrivateKeyShareStringEncryptor.append(cipherText, cipherChunk);
            } else {
                cipherText = cipher.doFinal(messageBytes);
            }
            retval = new String(Base64.encodeBase64(cipherText));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        return retval;
    }

    private static byte[] append(byte[] prefix, byte[] suffix) {
        int i;
        byte[] toReturn = new byte[prefix.length + suffix.length];
        for (i = 0; i < prefix.length; ++i) {
            toReturn[i] = prefix[i];
        }
        for (i = 0; i < suffix.length; ++i) {
            toReturn[i + prefix.length] = suffix[i];
        }
        return toReturn;
    }

    @Override
    public String decrypt(String encryptedMessage) {
        String retval = encryptedMessage;
        byte[] plainText = new byte[]{};
        if (this.privateKey == null) {
            throw new RuntimeException("Unable to decrypt value,  private key not found");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.encryptionAlgorithm);
            cipher.init(2, this.privateKey);
            int chunkSize = 64;
            byte[] messageBytes = Base64.decodeBase64(encryptedMessage.getBytes("UTF-8"));
            byte[] cipherChunk = new byte[]{};
            byte[] buffer = new byte[chunkSize];
            for (int i = 0; i < messageBytes.length; ++i) {
                if (i > 0 && i % chunkSize == 0) {
                    cipherChunk = cipher.doFinal(buffer);
                    plainText = PublicPrivateKeyShareStringEncryptor.append(plainText, cipherChunk);
                    int newlength = chunkSize;
                    if (i + chunkSize > messageBytes.length) {
                        newlength = messageBytes.length - i;
                    }
                    buffer = new byte[newlength];
                }
                buffer[i % chunkSize] = messageBytes[i];
            }
            cipherChunk = cipher.doFinal(buffer);
            plainText = PublicPrivateKeyShareStringEncryptor.append(plainText, cipherChunk);
            retval = new String(plainText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encrypt value", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Could not decrypt value", e);
        }
        return retval;
    }

    public void initPublic(String alfrescoSharedDir) {
        block9: {
            File webExtensionDir = this.getWebExtensionDir(alfrescoSharedDir);
            File publicKeyFile = new File(webExtensionDir, PUBKEYNAME);
            if (publicKeyFile.canRead()) {
                try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(publicKeyFile));){
                    this.publicKey = (PublicKey)is.readObject();
                    break block9;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not instantiate Public Key", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open Public Key", e);
                }
            }
            throw new RuntimeException("Public Key File Not Found :" + publicKeyFile.getPath());
        }
    }

    public void initPrivate(String alfrescoSharedDir) {
        File webExtension = this.getWebExtensionDir(alfrescoSharedDir);
        File privateKeyFile = new File(webExtension, PRIKEYNAME);
        if (privateKeyFile.canRead()) {
            ObjectInputStream is = null;
            try {
                is = new ObjectInputStream(new FileInputStream(privateKeyFile));
                this.privateKey = (PrivateKey)is.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find Private Key", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new RuntimeException("Private Key File Not Found :" + privateKeyFile.getPath());
    }

    public void createKeyFiles(String alfrescoSharedDir) {
        File sharedDir = new File(alfrescoSharedDir);
        File webExtensionDir = this.getWebExtensionDir(alfrescoSharedDir);
        if (!sharedDir.exists()) {
            throw new RuntimeException("alfresco shared dir does not exist : " + String.valueOf(sharedDir));
        }
        if (!webExtensionDir.exists()) {
            throw new RuntimeException("alfresco enterprise dir does not exist : " + String.valueOf(webExtensionDir));
        }
        File publicKeyFile = new File(webExtensionDir, PUBKEYNAME);
        File privateKeyFile = new File(webExtensionDir, PRIKEYNAME);
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.keyAlgorithm);
            keyGen.initialize(512);
            KeyPair key = keyGen.generateKeyPair();
            try (ObjectOutputStream publicKeyOS = new ObjectOutputStream(new FileOutputStream(publicKeyFile));){
                publicKeyOS.writeObject(key.getPublic());
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create public key file", e);
            }
            try (ObjectOutputStream privateKeyOS = new ObjectOutputStream(new FileOutputStream(privateKeyFile));){
                privateKeyOS.writeObject(key.getPrivate());
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create private key file", e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate public/private key", e);
        }
    }

    private File getWebExtensionDir(String alfrescoSharedDir) {
        File sharedDir = new File(alfrescoSharedDir);
        File alfrescoDir = new File(sharedDir, "alfresco");
        File webExtensionDir = new File(alfrescoDir, "web-extension");
        return webExtensionDir;
    }

    public String getPasswordFromConsole() {
        String enteredPassword = null;
        String verifyPassword = null;
        boolean firstOne = true;
        do {
            if (!firstOne) {
                System.console().writer().println("Please enter the same value twice to verify your encrypted value");
                System.console().writer().flush();
            }
            firstOne = false;
            System.console().writer().print("Please Enter Value: ");
            System.console().writer().flush();
            enteredPassword = new String(System.console().readPassword());
            System.console().writer().print("Please Repeat Value: ");
            System.console().writer().flush();
            verifyPassword = new String(System.console().readPassword());
        } while (enteredPassword == null || enteredPassword.length() < 1 || !enteredPassword.equals(verifyPassword));
        return enteredPassword;
    }

    public void init() {
        URL privateKeyURL = this.getClass().getResource(PRIKEYPATH);
        if (privateKeyURL == null) {
            return;
        }
        try {
            File privateKeyFile = new File(privateKeyURL.toURI());
            this.initPrivateKeyFile(privateKeyFile);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not instantiate Private Key", e);
        }
    }

    public void initConfig(String shareDir) {
        File privateKeyFile = new File(this.getWebExtensionDir(shareDir), PRIKEYNAME);
        this.initPrivateKeyFile(privateKeyFile);
    }

    private void initPrivateKeyFile(File privateKeyFile) {
        if (privateKeyFile.canRead()) {
            ObjectInputStream is = null;
            try {
                is = new ObjectInputStream(new FileInputStream(privateKeyFile));
                this.privateKey = (PrivateKey)is.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not instantiate Private Key", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException error) {
                        throw new RuntimeException("Problem while closing stream.", error);
                    }
                }
            }
        }
        throw new RuntimeException("Private Key File: " + privateKeyFile.getAbsolutePath() + " Cannot be read");
    }
}

