/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.Reader;
import java.io.StringReader;
import java.util.stream.IntStream;
import org.alfresco.solr.client.LookAheadBufferedReader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LookAheadBufferedReaderTest {
    @Mock
    Reader reader;
    private final String data = "1234567890ABCDEFGHILMNOPQRSTUVYXZ";

    @Test
    public void windowingModeEnabled() {
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader(this.reader, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length(), true, false);
        Assert.assertTrue((boolean)classUnderTest.isInWindowingMode());
        Assert.assertFalse((boolean)classUnderTest.isInCollectEverythingMode());
        Assert.assertFalse((boolean)classUnderTest.isBufferingDisabled());
    }

    @Test
    public void collectEverythingModeEnabled() {
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader(this.reader, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length(), false, true);
        Assert.assertTrue((boolean)classUnderTest.isInCollectEverythingMode());
        Assert.assertFalse((boolean)classUnderTest.isInWindowingMode());
        Assert.assertFalse((boolean)classUnderTest.isBufferingDisabled());
    }

    @Test
    public void bufferingDisabled() {
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader(this.reader, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length(), false, false);
        Assert.assertTrue((boolean)classUnderTest.isBufferingDisabled());
        Assert.assertFalse((boolean)classUnderTest.isInCollectEverythingMode());
        Assert.assertFalse((boolean)classUnderTest.isInWindowingMode());
    }

    @Test
    public void collectEverythingWinsOverWindowing() {
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader(this.reader, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length(), true, true);
        Assert.assertTrue((boolean)classUnderTest.isInCollectEverythingMode());
        Assert.assertFalse((boolean)classUnderTest.isInWindowingMode());
        Assert.assertFalse((boolean)classUnderTest.isBufferingDisabled());
    }

    @Test
    public void windowingModeShouldCollectPartialWindowsOfData() {
        int windowSize = 10;
        StringReader reader = new StringReader("1234567890ABCDEFGHILMNOPQRSTUVYXZ");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, windowSize, true, false);
        IntStream.range(0, 12).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedWindow = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((long)(windowSize * 2), (long)collectedWindow.length());
        Assert.assertEquals((Object)"4567890ABCDEFGHILMNO", (Object)collectedWindow);
    }

    @Test
    public void notEnoughCharsForTheWindow() {
        int windowSize = 10;
        StringReader reader = new StringReader("1234567890ABCDEFGHILMNOPQRSTUVYXZ");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, windowSize, true, false);
        IntStream.range(0, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length() - 3).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedWindow = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((long)(windowSize + 2), (long)collectedWindow.length());
        Assert.assertEquals((Object)"NOPQRSTUVYXZ", (Object)collectedWindow);
    }

    @Test
    public void emptyDataShouldCollectEmptyWindow() {
        StringReader reader = new StringReader("");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, 10, true, false);
        IntStream.range(0, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length() - 3).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedWindow = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((long)0L, (long)collectedWindow.length());
        Assert.assertEquals((Object)"", (Object)collectedWindow);
    }

    @Test
    public void collectEverythingModeShouldCollectTheWholeStream() {
        StringReader reader = new StringReader("1234567890ABCDEFGHILMNOPQRSTUVYXZ");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, 10, false, true);
        IntStream.range(0, 12).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedData = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((long)"1234567890ABCDEFGHILMNOPQRSTUVYXZ".length(), (long)collectedData.length());
        Assert.assertEquals((Object)"1234567890ABCDEFGHILMNOPQRSTUVYXZ", (Object)collectedData);
    }

    @Test
    public void emptyDataShouldCollectEmptyStringInCollectEverythingMode() {
        StringReader reader = new StringReader("");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, 10, false, true);
        IntStream.range(0, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length() - 3).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedData = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((long)0L, (long)collectedData.length());
        Assert.assertEquals((Object)"", (Object)collectedData);
    }

    @Test
    public void bufferingModeDisableShouldCollectNoData() {
        int windowSize = 10;
        StringReader reader = new StringReader("1234567890ABCDEFGHILMNOPQRSTUVYXZ");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, windowSize, false, false);
        IntStream.range(0, 12).forEach(index -> this.consume((Reader)classUnderTest));
        Assert.assertEquals((Object)"Not available: please set the logging LEVEL to DEBUG or TRACE.", (Object)classUnderTest.lookAheadAndGetBufferedContent());
    }

    @Test
    public void emptyDataShouldCollectEmptyDataWhenBufferingIsDisabled() {
        StringReader reader = new StringReader("");
        LookAheadBufferedReader classUnderTest = new LookAheadBufferedReader((Reader)reader, 10, false, false);
        IntStream.range(0, "1234567890ABCDEFGHILMNOPQRSTUVYXZ".length() - 3).forEach(index -> this.consume((Reader)classUnderTest));
        String collectedData = classUnderTest.lookAheadAndGetBufferedContent();
        Assert.assertEquals((Object)"Not available: please set the logging LEVEL to DEBUG or TRACE.", (Object)collectedData);
    }

    private void consume(Reader reader) {
        try {
            reader.read();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

