/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISStrictDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.mapping.RuntimePropertyLuceneBuilderMapping;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

public class SOLRAPIClientTest
extends TestCase {
    private static Log logger = LogFactory.getLog(SOLRAPIClientTest.class);
    private SOLRAPIClient client;
    private DictionaryDAOImpl dictionaryDAO;
    private CMISStrictDictionaryService cmisDictionaryService;
    private static final String CORENAME = "collection1";

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel);
            }
            this.dictionaryDAO.putModelIgnoringConstraints(model);
            loadedModels.add(modelName);
        }
    }

    public void setUp() throws Exception {
        if (this.client == null) {
            SingleTServiceImpl tenantService = new SingleTServiceImpl();
            DictionaryDAOImpl namespaceDAO = this.dictionaryDAO = new DictionaryDAOImpl();
            this.dictionaryDAO.setTenantService((TenantService)tenantService);
            CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
            compiledModelsCache.setDictionaryDAO(this.dictionaryDAO);
            compiledModelsCache.setTenantService((TenantService)tenantService);
            compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
            TraceableThreadFactory threadFactory = new TraceableThreadFactory();
            threadFactory.setThreadDaemon(true);
            threadFactory.setThreadPriority(5);
            DynamicallySizedThreadPoolExecutor threadPoolExecutor = new DynamicallySizedThreadPoolExecutor(20, 20, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue(), (ThreadFactory)threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolExecutor);
            this.dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
            this.dictionaryDAO.setResourceClassLoader(this.getResourceClassLoader());
            this.dictionaryDAO.init();
            DictionaryComponent dictionaryComponent = new DictionaryComponent();
            dictionaryComponent.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
            dictionaryComponent.setMessageLookup((MessageLookup)new StaticMessageLookup());
            CMISMapping cmisMapping = new CMISMapping();
            cmisMapping.setCmisVersion(CmisVersion.CMIS_1_0);
            DictionaryNamespaceComponent namespaceService = new DictionaryNamespaceComponent();
            namespaceService.setNamespaceDAO((NamespaceDAO)namespaceDAO);
            cmisMapping.setNamespaceService((NamespaceService)namespaceService);
            cmisMapping.setDictionaryService((DictionaryService)dictionaryComponent);
            cmisMapping.afterPropertiesSet();
            this.cmisDictionaryService = new CMISStrictDictionaryService();
            this.cmisDictionaryService.setCmisMapping(cmisMapping);
            this.cmisDictionaryService.setDictionaryService((DictionaryService)dictionaryComponent);
            this.cmisDictionaryService.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
            this.cmisDictionaryService.setSingletonCache((SimpleCache)new MemoryCache());
            this.cmisDictionaryService.setTenantService((TenantService)tenantService);
            this.cmisDictionaryService.init();
            RuntimePropertyLuceneBuilderMapping luceneBuilderMapping = new RuntimePropertyLuceneBuilderMapping();
            luceneBuilderMapping.setDictionaryService((DictionaryService)dictionaryComponent);
            luceneBuilderMapping.setCmisDictionaryService((CMISDictionaryService)this.cmisDictionaryService);
            this.cmisDictionaryService.setPropertyLuceneBuilderMapping((PropertyLuceneBuilderMapping)luceneBuilderMapping);
            luceneBuilderMapping.afterPropertiesSet();
            ClasspathKeyResourceLoader keyResourceLoader = new ClasspathKeyResourceLoader();
            this.client = new SOLRAPIClient(this.getRepoClient(keyResourceLoader), (DictionaryService)dictionaryComponent, (NamespaceDAO)this.dictionaryDAO);
            this.trackModels();
        }
    }

    private void trackModels() throws AuthenticationException, IOException, JSONException {
        List modelDiffs = this.client.getModelsDiff(CORENAME, Collections.emptyList());
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        block4: for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    AlfrescoModel changedModel = this.client.getModel(CORENAME, modelDiff.getModelName());
                    for (M2Namespace namespace : changedModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), changedModel.getModel());
                    }
                    continue block4;
                }
                case NEW: {
                    AlfrescoModel newModel = this.client.getModel(CORENAME, modelDiff.getModelName());
                    for (M2Namespace namespace : newModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), newModel.getModel());
                    }
                    continue block4;
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model);
        }
        if (modelDiffs.size() > 0) {
            this.afterInitModels();
        }
    }

    public void afterInitModels() {
        this.cmisDictionaryService.afterDictionaryInit();
    }

    protected AlfrescoHttpClient getRepoClient(ClasspathKeyResourceLoader keyResourceLoader) {
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters("SSL Key Store", "JCEKS", null, "ssl-keystore-passwords.properties", "ssl.repo.client.keystore");
        KeyStoreParameters trustStoreParameters = new KeyStoreParameters("SSL Trust Store", "JCEKS", null, "ssl-truststore-passwords.properties", "ssl.repo.client.truststore");
        SSLEncryptionParameters sslEncryptionParameters = new SSLEncryptionParameters(keyStoreParameters, trustStoreParameters);
        HttpClientFactory httpClientFactory = new HttpClientFactory(HttpClientFactory.SecureCommsType.getType((String)"https"), sslEncryptionParameters, (KeyResourceLoader)keyResourceLoader, null, null, "localhost", 8080, 8443, 40, 40, 0);
        return httpClientFactory.getRepoClient("localhost", 8443);
    }

    public ClassLoader getResourceClassLoader() {
        File f = new File("woof", "alfrescoResources");
        if (f.canRead() && f.isDirectory()) {
            URL[] urls = new URL[1];
            try {
                URL url;
                urls[0] = url = f.toURI().normalize().toURL();
            }
            catch (MalformedURLException e) {
                throw new AlfrescoRuntimeException("Failed to add resources to classpath ", (Throwable)e);
            }
            return URLClassLoader.newInstance(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void testGetAcls() throws Exception {
        AclChangeSets aclChangeSets = null;
        aclChangeSets = this.client.getAclChangeSets(null, null, null, null, 50);
        SOLRAPIClientTest.assertTrue((String)"Too many results", (aclChangeSets.getAclChangeSets().size() <= 50 ? 1 : 0) != 0);
        if (aclChangeSets.getAclChangeSets().size() < 2) {
            return;
        }
        AclChangeSet aclChangeSetCheck = null;
        AclChangeSet aclChangeSet0 = (AclChangeSet)aclChangeSets.getAclChangeSets().get(0);
        AclChangeSet aclChangeSet1 = (AclChangeSet)aclChangeSets.getAclChangeSets().get(1);
        long id0 = aclChangeSet0.getId();
        long commitTimeMs0 = aclChangeSet0.getCommitTimeMs();
        Long nextId = id0 + 1L;
        aclChangeSets = this.client.getAclChangeSets(Long.valueOf(commitTimeMs0), nextId, null, null, 1);
        SOLRAPIClientTest.assertEquals((int)1, (int)aclChangeSets.getAclChangeSets().size());
        aclChangeSetCheck = (AclChangeSet)aclChangeSets.getAclChangeSets().get(0);
        SOLRAPIClientTest.assertEquals((Object)aclChangeSet1, (Object)aclChangeSetCheck);
        HashMap<Long, AclChangeSet> aclChangeSetsById = new HashMap<Long, AclChangeSet>();
        for (AclChangeSet aclChangeSet : aclChangeSets.getAclChangeSets()) {
            aclChangeSetsById.put(aclChangeSet.getId(), aclChangeSet);
        }
        HashSet<Long> aclIdUniqueCheck = new HashSet<Long>(1000);
        Long minAclChangeSetId = null;
        Long fromCommitTimeMs = null;
        for (int i = 0; i < 100 && (aclChangeSets = this.client.getAclChangeSets(fromCommitTimeMs, minAclChangeSetId, null, null, 10)).getAclChangeSets().size() != 0; ++i) {
            List acls;
            Long nextAclId = null;
            while ((acls = this.client.getAcls(aclChangeSets.getAclChangeSets(), nextAclId, 512)).size() != 0) {
                HashSet<Long> aclIds = new HashSet<Long>(1000);
                for (Acl acl : acls) {
                    long aclId = acl.getId();
                    aclIds.add(aclId);
                    if (!aclIdUniqueCheck.add(aclId)) {
                        // empty if block
                    }
                    if (nextAclId != null) {
                        SOLRAPIClientTest.assertTrue((String)("ACL IDs must be ascending: " + aclId), (nextAclId <= aclId ? 1 : 0) != 0);
                    }
                    nextAclId = aclId + 1L;
                }
                List aclsReaders = this.client.getAclReaders(acls);
                for (AclReaders aclReaders : aclsReaders) {
                    Long aclId = aclReaders.getId();
                    aclIds.remove(aclId);
                }
                SOLRAPIClientTest.assertTrue((String)("Some ACL IDs were not covered: " + String.valueOf(aclIds)), (aclIds.size() == 0 ? 1 : 0) != 0);
            }
            AclChangeSet lastAclChangeSet = (AclChangeSet)aclChangeSets.getAclChangeSets().get(aclChangeSets.getAclChangeSets().size() - 1);
            fromCommitTimeMs = lastAclChangeSet.getCommitTimeMs();
            minAclChangeSetId = lastAclChangeSet.getId() + 1L;
        }
    }

    public void testGetTransactions() throws Exception {
        Transactions transactions = this.client.getTransactions(Long.valueOf(1298288417234L), null, null, null, 5);
        transactions = this.client.getTransactions(null, Long.valueOf(1L), null, null, 5);
        ArrayList<Long> transactionIds = new ArrayList<Long>(transactions.getTransactions().size());
        for (Transaction info : transactions.getTransactions()) {
            logger.debug((Object)info);
            transactionIds.add(info.getId());
        }
        GetNodesParameters params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        List nodes = this.client.getNodes(params, 5);
        for (Object info : nodes) {
            logger.debug(info);
        }
        params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        params.setFromNodeId(Long.valueOf(((Node)nodes.get(nodes.size() - 1)).getId()));
        nodes = this.client.getNodes(params, 3);
        ArrayList<Long> nodeIds = new ArrayList<Long>(nodes.size());
        for (Node info : nodes) {
            logger.debug((Object)info);
            nodeIds.add(info.getId());
        }
        NodeMetaDataParameters metaParams = new NodeMetaDataParameters();
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        List metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
    }

    public void testMetaData() throws AuthenticationException, IOException, JSONException {
        NodeMetaDataParameters metaParams = new NodeMetaDataParameters();
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(1L);
        metaParams.setMaxResults(3);
        metaParams.setNodeIds(nodeIds);
        List metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(9L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(19L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(49437L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(49431L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
            MultiPropertyValue multi = (MultiPropertyValue)info.getProperties().get(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}taggable"));
            if (multi == null) continue;
            for (PropertyValue propValue : multi.getValues()) {
                logger.debug((Object)("multi property values = " + String.valueOf(propValue)));
            }
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(117630L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(117678L);
        metaParams.setNodeIds(nodeIds);
        metaParams.setMaxResults(3);
        metadata = this.client.getNodesMetaData(metaParams);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
    }

    public void testGetModel() throws AuthenticationException, IOException, JSONException {
        AlfrescoModel alfModel = this.client.getModel(CORENAME, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"contentmodel"));
        M2Model model = alfModel.getModel();
        SOLRAPIClientTest.assertNotNull((Object)model);
        SOLRAPIClientTest.assertEquals((String)"Returned model has incorrect name", (String)"cm:contentmodel", (String)model.getName());
        SOLRAPIClientTest.assertNotNull((Object)alfModel.getChecksum());
    }

    public void testGetModelDiffs() throws AuthenticationException, IOException, JSONException {
        List diffs = this.client.getModelsDiff(CORENAME, Collections.emptyList());
        SOLRAPIClientTest.assertTrue((diffs.size() > 0 ? 1 : 0) != 0);
    }

    private class ClasspathKeyResourceLoader
    implements KeyResourceLoader {
        private ClasspathKeyResourceLoader() {
        }

        public InputStream getKeyStore(String location) throws FileNotFoundException {
            return this.getClass().getClassLoader().getResourceAsStream(location);
        }

        public Properties loadKeyMetaData(String location) throws IOException {
            Properties p = new Properties();
            p.load(this.getClass().getClassLoader().getResourceAsStream(location));
            return p;
        }
    }
}

