/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick.transformers;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.executors.AbstractCommandExecutor;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.base.util.Util;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.imagemagick.ImageMagickOptionsBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImageMagickTransformer
extends AbstractCommandExecutor
implements CustomTransformerFileAdaptor {
    private final List<String> singlePageFormats = List.of("image/bmp", "image/jp2", "image/jpeg", "image/png", "image/x-xwindowdump");
    @Value(value="${transform.core.imagemagick.exe}")
    private String exe;
    @Value(value="${transform.core.imagemagick.dyn}")
    private String dyn;
    @Value(value="${transform.core.imagemagick.root}")
    private String root;
    @Value(value="${transform.core.imagemagick.coders}")
    private String coders;
    @Value(value="${transform.core.imagemagick.config}")
    private String config;

    @PostConstruct
    private void createCommands() {
        if (this.exe == null || this.exe.isEmpty()) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_EXE variable cannot be null or empty");
        }
        if (this.dyn == null || this.dyn.isEmpty()) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_DYN variable cannot be null or empty");
        }
        if (this.root == null || this.root.isEmpty()) {
            throw new IllegalArgumentException("ImageMagickTransformer IMAGEMAGICK_ROOT variable cannot be null or empty");
        }
        this.transformCommand = this.createTransformCommand();
        this.checkCommand = this.createCheckCommand();
    }

    public String getTransformerName() {
        return "imagemagick";
    }

    protected RuntimeExec createTransformCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "${source}", "SPLIT:${options}", "-strip", "-quiet", "${target}"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        HashMap<String, String> processProperties = new HashMap<String, String>();
        processProperties.put("MAGICK_HOME", this.root);
        processProperties.put("DYLD_FALLBACK_LIBRARY_PATH", this.dyn);
        processProperties.put("LD_LIBRARY_PATH", this.dyn);
        if (this.coders != null && !this.coders.isBlank()) {
            processProperties.put("MAGICK_CODER_MODULE_PATH", this.coders);
        }
        if (this.config != null && !this.config.isBlank()) {
            processProperties.put("MAGICK_CONFIGURE_PATH", this.config);
        }
        runtimeExec.setProcessProperties(processProperties);
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        defaultProperties.put("options", null);
        runtimeExec.setDefaultProperties(defaultProperties);
        runtimeExec.setErrorCodes("1,2,255,400,405,410,415,420,425,430,435,440,450,455,460,465,470,475,480,485,490,495,499,700,705,710,715,720,725,730,735,740,750,755,760,765,770,775,780,785,790,795,799");
        return runtimeExec;
    }

    protected RuntimeExec createCheckCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "-version"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        return runtimeExec;
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws TransformException {
        String startPageString = transformOptions.get("startPage");
        String endPageString = transformOptions.get("endPage");
        if (!this.singlePageFormats.contains(sourceMimetype) && this.singlePageFormats.contains(targetMimetype)) {
            if (StringUtils.isEmpty((CharSequence)startPageString)) {
                startPageString = "0";
            }
            if (StringUtils.isEmpty((CharSequence)endPageString)) {
                endPageString = startPageString;
            }
        }
        String options = ImageMagickOptionsBuilder.builder().withStartPage(startPageString).withEndPage(endPageString).withAlphaRemove(transformOptions.get("alphaRemove")).withAutoOrient(transformOptions.get("autoOrient")).withCropGravity(transformOptions.get("cropGravity")).withCropWidth(transformOptions.get("cropWidth")).withCropHeight(transformOptions.get("cropHeight")).withCropPercentage(transformOptions.get("cropPercentage")).withCropXOffset(transformOptions.get("cropXOffset")).withCropYOffset(transformOptions.get("cropYOffset")).withThumbnail(transformOptions.get("thumbnail")).withResizeWidth(transformOptions.get("resizeWidth")).withResizeHeight(transformOptions.get("resizeHeight")).withResizePercentage(transformOptions.get("resizePercentage")).withAllowEnlargement(transformOptions.get("allowEnlargement")).withMaintainAspectRatio(transformOptions.get("maintainAspectRatio")).withCommandOptions(transformOptions.get("commandOptions")).build();
        String pageRange = ImageMagickTransformer.calculatePageRange((Integer)Util.stringToInteger((String)startPageString), (Integer)Util.stringToInteger((String)endPageString));
        Long timeout = Util.stringToLong((String)transformOptions.get("timeout"));
        this.run(options, sourceFile, pageRange, targetFile, timeout);
    }

    private static String calculatePageRange(Integer startPage, Integer endPage) {
        return startPage == null ? (endPage == null ? "" : "[" + endPage + "]") : (endPage == null || startPage.equals(endPage) ? "[" + startPage + "]" : "[" + startPage + "-" + endPage + "]");
    }
}

