/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import org.alfresco.transform.base.util.Util;
import org.alfresco.transform.exceptions.TransformException;
import org.springframework.http.HttpStatus;

public final class ImageMagickOptionsBuilder {
    private static final List<String> GRAVITY_VALUES = ImmutableList.of((Object)"North", (Object)"NorthEast", (Object)"East", (Object)"SouthEast", (Object)"South", (Object)"SouthWest", (Object)"West", (Object)"NorthWest", (Object)"Center");
    private Boolean alphaRemove;
    private Boolean autoOrient;
    private String cropGravity;
    private Integer cropWidth;
    private Integer cropHeight;
    private Boolean cropPercentage;
    private Integer cropXOffset;
    private Integer cropYOffset;
    private Boolean thumbnail;
    private Integer resizeWidth;
    private Integer resizeHeight;
    private Boolean resizePercentage;
    private Boolean allowEnlargement;
    private Boolean maintainAspectRatio;
    private String commandOptions;

    private ImageMagickOptionsBuilder() {
    }

    public ImageMagickOptionsBuilder withAlphaRemove(String alphaRemove) {
        return this.withAlphaRemove(Util.stringToBoolean((String)alphaRemove));
    }

    public ImageMagickOptionsBuilder withAlphaRemove(Boolean alphaRemove) {
        this.alphaRemove = alphaRemove;
        return this;
    }

    public ImageMagickOptionsBuilder withAutoOrient(String autoOrient) {
        return this.withAutoOrient(Util.stringToBoolean((String)autoOrient));
    }

    public ImageMagickOptionsBuilder withAutoOrient(Boolean autoOrient) {
        this.autoOrient = autoOrient == null ? true : autoOrient;
        return this;
    }

    public ImageMagickOptionsBuilder withCropGravity(String cropGravity) {
        this.cropGravity = cropGravity;
        return this;
    }

    public ImageMagickOptionsBuilder withCropWidth(String cropWidth) {
        return this.withCropWidth(Util.stringToInteger((String)cropWidth));
    }

    public ImageMagickOptionsBuilder withCropWidth(Integer cropWidth) {
        this.cropWidth = cropWidth;
        return this;
    }

    public ImageMagickOptionsBuilder withCropHeight(String cropHeight) {
        return this.withCropHeight(Util.stringToInteger((String)cropHeight));
    }

    public ImageMagickOptionsBuilder withCropHeight(Integer cropHeight) {
        this.cropHeight = cropHeight;
        return this;
    }

    public ImageMagickOptionsBuilder withCropPercentage(String cropPercentage) {
        return this.withCropPercentage(Util.stringToBoolean((String)cropPercentage));
    }

    public ImageMagickOptionsBuilder withCropPercentage(Boolean cropPercentage) {
        this.cropPercentage = cropPercentage;
        return this;
    }

    public ImageMagickOptionsBuilder withCropXOffset(String cropXOffset) {
        return this.withCropXOffset(Util.stringToInteger((String)cropXOffset));
    }

    public ImageMagickOptionsBuilder withCropXOffset(Integer cropXOffset) {
        this.cropXOffset = cropXOffset;
        return this;
    }

    public ImageMagickOptionsBuilder withCropYOffset(String cropYOffset) {
        return this.withCropYOffset(Util.stringToInteger((String)cropYOffset));
    }

    public ImageMagickOptionsBuilder withCropYOffset(Integer cropYOffset) {
        this.cropYOffset = cropYOffset;
        return this;
    }

    public ImageMagickOptionsBuilder withThumbnail(String thumbnail) {
        return this.withThumbnail(Util.stringToBoolean((String)thumbnail));
    }

    public ImageMagickOptionsBuilder withThumbnail(Boolean thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public ImageMagickOptionsBuilder withResizeWidth(String resizeWidth) {
        return this.withResizeWidth(Util.stringToInteger((String)resizeWidth));
    }

    public ImageMagickOptionsBuilder withResizeWidth(Integer resizeWidth) {
        this.resizeWidth = resizeWidth;
        return this;
    }

    public ImageMagickOptionsBuilder withResizeHeight(String resizeHeight) {
        return this.withResizeHeight(Util.stringToInteger((String)resizeHeight));
    }

    public ImageMagickOptionsBuilder withResizeHeight(Integer resizeHeight) {
        this.resizeHeight = resizeHeight;
        return this;
    }

    public ImageMagickOptionsBuilder withResizePercentage(String resizePercentage) {
        return this.withResizePercentage(Util.stringToBoolean((String)resizePercentage));
    }

    public ImageMagickOptionsBuilder withResizePercentage(Boolean resizePercentage) {
        this.resizePercentage = resizePercentage;
        return this;
    }

    public ImageMagickOptionsBuilder withAllowEnlargement(String allowEnlargement) {
        return this.withAllowEnlargement(Util.stringToBoolean((String)allowEnlargement));
    }

    public ImageMagickOptionsBuilder withAllowEnlargement(Boolean allowEnlargement) {
        this.allowEnlargement = allowEnlargement == null ? true : allowEnlargement;
        return this;
    }

    public ImageMagickOptionsBuilder withMaintainAspectRatio(String maintainAspectRatio) {
        return this.withMaintainAspectRatio(Util.stringToBoolean((String)maintainAspectRatio));
    }

    public ImageMagickOptionsBuilder withMaintainAspectRatio(Boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
        return this;
    }

    public ImageMagickOptionsBuilder withCommandOptions(String commandOptions) {
        this.commandOptions = commandOptions;
        return this;
    }

    public String build() {
        if (this.cropGravity != null) {
            this.cropGravity = this.cropGravity.trim();
            if (this.cropGravity.isEmpty()) {
                this.cropGravity = null;
            } else if (!GRAVITY_VALUES.contains(this.cropGravity)) {
                throw new TransformException(HttpStatus.BAD_REQUEST, "Invalid cropGravity value");
            }
        }
        StringJoiner args = new StringJoiner(" ");
        if (this.alphaRemove != null && this.alphaRemove.booleanValue()) {
            args.add("-alpha");
            args.add("remove");
        }
        if (this.autoOrient != null && this.autoOrient.booleanValue()) {
            args.add("-auto-orient");
        }
        if (this.cropGravity != null || this.cropWidth != null || this.cropHeight != null || this.cropPercentage != null || this.cropXOffset != null || this.cropYOffset != null) {
            if (this.cropGravity != null) {
                args.add("-gravity");
                args.add(this.cropGravity);
            }
            StringBuilder crop = new StringBuilder();
            if (this.cropWidth != null && this.cropWidth >= 0) {
                crop.append(this.cropWidth);
            }
            if (this.cropHeight != null && this.cropHeight >= 0) {
                crop.append('x');
                crop.append(this.cropHeight);
            }
            if (this.cropPercentage != null && this.cropPercentage.booleanValue()) {
                crop.append('%');
            }
            if (this.cropXOffset != null) {
                if (this.cropXOffset >= 0) {
                    crop.append('+');
                }
                crop.append(this.cropXOffset);
            }
            if (this.cropYOffset != null) {
                if (this.cropYOffset >= 0) {
                    crop.append('+');
                }
                crop.append(this.cropYOffset);
            }
            if (crop.length() > 1) {
                args.add("-crop");
                args.add(crop);
            }
            args.add("+repage");
        }
        if (this.resizeHeight != null || this.resizeWidth != null || this.resizePercentage != null || this.maintainAspectRatio != null) {
            args.add(this.thumbnail != null && this.thumbnail != false ? "-thumbnail" : "-resize");
            StringBuilder resize = new StringBuilder();
            if (this.resizeWidth != null && this.resizeWidth >= 0) {
                resize.append(this.resizeWidth);
            }
            if (this.resizeHeight != null && this.resizeHeight >= 0) {
                resize.append('x');
                resize.append(this.resizeHeight);
            }
            if (this.resizePercentage != null && this.resizePercentage.booleanValue()) {
                resize.append('%');
            }
            if (this.allowEnlargement == null || !this.allowEnlargement.booleanValue()) {
                resize.append('>');
            }
            if (this.maintainAspectRatio != null && !this.maintainAspectRatio.booleanValue()) {
                resize.append('!');
            }
            if (resize.length() > 1) {
                args.add(resize);
            }
        }
        return (String)(this.commandOptions == null || "".equals(this.commandOptions.trim()) ? "" : this.commandOptions + " ") + String.valueOf(args);
    }

    public static ImageMagickOptionsBuilder builder() {
        return new ImageMagickOptionsBuilder();
    }
}

