/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick.transformers;

import java.io.File;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.base.util.Util;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.imagemagick.ImageMagickOptionsBuilder;
import org.alfresco.transform.imagemagick.transformers.ImageMagickCommandExecutor;
import org.alfresco.transform.imagemagick.transformers.ImageMagickCommandOptions;
import org.alfresco.transform.imagemagick.transformers.page.PageRangeFactory;
import org.springframework.stereotype.Component;

@Component
public class ImageMagickTransformer
implements CustomTransformerFileAdaptor {
    private final ImageMagickCommandExecutor imageMagickCommandExecutor;
    private final PageRangeFactory pageRangeFactory;
    private final ImageMagickCommandOptions imageMagickCommandOptions;

    public ImageMagickTransformer(ImageMagickCommandExecutor imageMagickCommandExecutor, PageRangeFactory pageRangeFactory, ImageMagickCommandOptions imageMagickCommandOptions) {
        this.imageMagickCommandExecutor = imageMagickCommandExecutor;
        this.pageRangeFactory = pageRangeFactory;
        this.imageMagickCommandOptions = imageMagickCommandOptions;
    }

    public String getTransformerName() {
        return "imagemagick";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws TransformException {
        ImageMagickOptionsBuilder builder = ImageMagickOptionsBuilder.builder().withAlphaRemove(transformOptions.get("alphaRemove")).withAutoOrient(transformOptions.get("autoOrient")).withCropGravity(transformOptions.get("cropGravity")).withCropWidth(transformOptions.get("cropWidth")).withCropHeight(transformOptions.get("cropHeight")).withCropPercentage(transformOptions.get("cropPercentage")).withCropXOffset(transformOptions.get("cropXOffset")).withCropYOffset(transformOptions.get("cropYOffset")).withThumbnail(transformOptions.get("thumbnail")).withResizeWidth(transformOptions.get("resizeWidth")).withResizeHeight(transformOptions.get("resizeHeight")).withResizePercentage(transformOptions.get("resizePercentage")).withAllowEnlargement(transformOptions.get("allowEnlargement")).withMaintainAspectRatio(transformOptions.get("maintainAspectRatio"));
        if (this.imageMagickCommandOptions.isCommandOptionsEnabled()) {
            builder.withCommandOptions(transformOptions.get("commandOptions"));
        }
        String options = builder.build();
        String pageRange = this.pageRangeFactory.create(sourceMimetype, targetMimetype, transformOptions);
        Long timeout = Util.stringToLong((String)transformOptions.get("timeout"));
        this.imageMagickCommandExecutor.run(options, sourceFile, pageRange, targetFile, timeout);
    }
}

