/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice;

import com.google.common.collect.ImmutableSet;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.clients.FileInfo;
import org.alfresco.transform.base.clients.HttpClient;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class LibreOfficeTransformationIT {
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficeTransformationIT.class);
    private static final String ENGINE_URL = "http://localhost:8090";
    private static final Set<FileInfo> spreadsheetTargets = ImmutableSet.of((Object)FileInfo.testFile((String)"text/csv", (String)"csv", null), (Object)FileInfo.testFile((String)"text/html", (String)"html", null), (Object)FileInfo.testFile((String)"application/vnd.oasis.opendocument.spreadsheet", (String)"ods", null), (Object)FileInfo.testFile((String)"application/pdf", (String)"pdf", null), (Object)FileInfo.testFile((String)"text/tab-separated-values", (String)"tsv", null), (Object)FileInfo.testFile((String)"application/vnd.ms-excel", (String)"xls", null), (Object[])new FileInfo[0]);
    private static final Set<FileInfo> documentsTargets = ImmutableSet.of((Object)FileInfo.testFile((String)"application/msword", (String)"doc", null), (Object)FileInfo.testFile((String)"text/html", (String)"html", null), (Object)FileInfo.testFile((String)"application/vnd.oasis.opendocument.text", (String)"odt", null), (Object)FileInfo.testFile((String)"application/pdf", (String)"pdf", null), (Object)FileInfo.testFile((String)"application/rtf", (String)"rtf", null));
    private static final Set<FileInfo> graphicTargets = ImmutableSet.of((Object)FileInfo.testFile((String)"application/pdf", (String)"pdf", null), (Object)FileInfo.testFile((String)"image/svg+xml", (String)"svg", null));
    private static final Set<FileInfo> presentationTargets = ImmutableSet.of((Object)FileInfo.testFile((String)"text/html", (String)"html", null), (Object)FileInfo.testFile((String)"application/vnd.oasis.opendocument.presentation", (String)"odp", null), (Object)FileInfo.testFile((String)"application/vnd.ms-powerpoint", (String)"ppt", null), (Object)FileInfo.testFile((String)"application/pdf", (String)"pdf", null));
    private static final Set<FileInfo> pdfTarget = ImmutableSet.of((Object)FileInfo.testFile((String)"application/pdf", (String)"pdf", null));
    private static final Set<FileInfo> txtTarget = ImmutableSet.of((Object)FileInfo.testFile((String)"text/plain", (String)"txt", null));
    private static final Map<String, FileInfo> TEST_FILES = Stream.of(FileInfo.testFile((String)"application/msword", (String)"doc", (String)"quick.doc"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)"docx", (String)"quick.docx"), FileInfo.testFile((String)"application/vnd.oasis.opendocument.graphics", (String)"odg", (String)"quick.odg"), FileInfo.testFile((String)"application/vnd.oasis.opendocument.presentation", (String)"odp", (String)"quick.odp"), FileInfo.testFile((String)"application/vnd.oasis.opendocument.spreadsheet", (String)"ods", (String)"quick.ods"), FileInfo.testFile((String)"application/vnd.oasis.opendocument.text", (String)"odt", (String)"quick.odt"), FileInfo.testFile((String)"application/vnd.ms-powerpoint", (String)"ppt", (String)"quick.ppt"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (String)"pptx", (String)"quick.pptx"), FileInfo.testFile((String)"application/vnd.visio", (String)"vdx", (String)"quick.vdx"), FileInfo.testFile((String)"application/vnd.visio2013", (String)"vsd", (String)"quick.vsd"), FileInfo.testFile((String)"application/wordperfect", (String)"wpd", (String)"quick.wpd"), FileInfo.testFile((String)"application/vnd.ms-excel", (String)"xls", (String)"quick.xls"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (String)"xlsx", (String)"quick.xlsx"), FileInfo.testFile((String)"text/csv", (String)"csv", (String)"people.csv"), FileInfo.testFile((String)"application/rtf", (String)"rtf", (String)"sample.rtf"), FileInfo.testFile((String)"text/html", (String)"html", (String)"quick.html"), FileInfo.testFile((String)"text/xml", (String)"xml", (String)"quick.xml"), FileInfo.testFile((String)"application/vnd.ms-excel.template.macroenabled.12", (String)"xltm", (String)"quick.xltm"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.presentationml.slideshow", (String)"ppsx", (String)"quick.ppsx"), FileInfo.testFile((String)"application/vnd.ms-powerpoint.slideshow.macroenabled.12", (String)"ppsm", (String)"quick.ppsm"), FileInfo.testFile((String)"application/dita+xml", (String)"dita", (String)"quick.dita"), FileInfo.testFile((String)"text/plain", (String)"txt", (String)"quick.txt"), FileInfo.testFile((String)"application/vnd.sun.xml.calc.template", (String)"stc", (String)"quick.stc"), FileInfo.testFile((String)"application/vnd.sun.xml.impress.template", (String)"sti", (String)"quick.sti"), FileInfo.testFile((String)"application/vnd.sun.xml.writer.template", (String)"stw", (String)"quick.stw"), FileInfo.testFile((String)"application/vnd.sun.xml.calc", (String)"sxc", (String)"quick.sxc"), FileInfo.testFile((String)"application/vnd.sun.xml.impress", (String)"sxi", (String)"quick.sxi"), FileInfo.testFile((String)"text/tab-separated-values", (String)"tsv", (String)"sample.tsv")).collect(Collectors.toMap(FileInfo::getPath, Function.identity()));

    public static Stream<Pair<FileInfo, FileInfo>> engineTransformations() {
        return Stream.of(LibreOfficeTransformationIT.allTargets("quick.doc", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.docx", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.html", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.odt", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.wpd", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.txt", documentsTargets), LibreOfficeTransformationIT.allTargets("sample.rtf", documentsTargets), LibreOfficeTransformationIT.allTargets("quick.odp", presentationTargets), LibreOfficeTransformationIT.allTargets("quick.ppt", presentationTargets), LibreOfficeTransformationIT.allTargets("quick.pptx", presentationTargets), LibreOfficeTransformationIT.allTargets("quick.odg", graphicTargets), LibreOfficeTransformationIT.allTargets("quick.vdx", graphicTargets), LibreOfficeTransformationIT.allTargets("quick.vsd", graphicTargets), LibreOfficeTransformationIT.allTargets("quick.ods", spreadsheetTargets), LibreOfficeTransformationIT.allTargets("quick.xls", spreadsheetTargets), LibreOfficeTransformationIT.allTargets("quick.xlsx", spreadsheetTargets), LibreOfficeTransformationIT.allTargets("people.csv", spreadsheetTargets), LibreOfficeTransformationIT.allTargets("sample.tsv", spreadsheetTargets), LibreOfficeTransformationIT.allTargets("quick.xml", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.xltm", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.dita", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.ppsm", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.ppsx", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.stc", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.sti", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.stw", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.sxc", pdfTarget), LibreOfficeTransformationIT.allTargets("quick.sxi", pdfTarget)).flatMap(Function.identity());
    }

    @ParameterizedTest
    @MethodSource(value={"engineTransformations"})
    public void testTransformation(Pair<FileInfo, FileInfo> entry) {
        String sourceFile = ((FileInfo)entry.getLeft()).getPath();
        String targetExtension = ((FileInfo)entry.getRight()).getExtension();
        String sourceMimetype = ((FileInfo)entry.getLeft()).getMimeType();
        String targetMimetype = ((FileInfo)entry.getRight()).getMimeType();
        String descriptor = MessageFormat.format("Transform ({0}, {1} -> {2}, {3})", sourceFile, sourceMimetype, targetMimetype, targetExtension);
        try {
            ResponseEntity response = HttpClient.sendTRequest((String)ENGINE_URL, (String)sourceFile, (String)sourceMimetype, (String)targetMimetype, (String)targetExtension);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)descriptor);
        }
        catch (Exception e) {
            Assertions.fail((String)(descriptor + " exception: " + e.getMessage()));
        }
    }

    private static Stream<Pair<FileInfo, FileInfo>> allTargets(String sourceFile, Set<FileInfo> mimetypes) {
        return mimetypes.stream().filter(type -> !type.getMimeType().equals(TEST_FILES.get(sourceFile).getMimeType())).filter(type -> !TEST_FILES.get(sourceFile).getMimeType().equals("application/vnd.oasis.opendocument.spreadsheet") || !type.getMimeType().equals("text/csv")).map(k -> Pair.of((Object)TEST_FILES.get(sourceFile), (Object)k));
    }
}

