/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice;

import java.util.Collections;
import org.alfresco.transform.base.TransformEngine;
import org.alfresco.transform.base.logging.StandardMessages;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.reader.TransformConfigResourceReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LibreOfficeTransformEngine
implements TransformEngine {
    @Autowired
    private TransformConfigResourceReader transformConfigResourceReader;

    public String getTransformEngineName() {
        return "0020 LibreOffice";
    }

    public String getStartupMessage() {
        return StandardMessages.COMMUNITY_LICENCE + "This transformer uses LibreOffice from The Document Foundation. See the license at https://www.libreoffice.org/download/license/ or in /libreoffice.txt";
    }

    public TransformConfig getTransformConfig() {
        return this.transformConfigResourceReader.read("classpath:libreoffice_engine_config.json");
    }

    public ProbeTransform getProbeTransform() {
        return new ProbeTransform("probe.doc", "application/msword", "application/pdf", Collections.emptyMap(), 9728L, 1024L, 150, 10240L, 1801L, 920L);
    }
}

