/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.fs.FileManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.misc.transformers.HtmlParserContentTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EMLTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(EMLTransformer.class);
    private static final String CHARSET = "charset";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public String getTransformerName() {
        return "rfc822";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws Exception {
        logger.debug("Performing RFC822 to text transform.");
        try (BufferedInputStream contentInputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             BufferedWriter bufferedFileWriter = new BufferedWriter(new FileWriter(targetFile));){
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)contentInputStream);
            StringBuilder sb = new StringBuilder();
            Object content = mimeMessage.getContent();
            if (content instanceof Multipart) {
                this.processMultiPart((Multipart)content, sb);
            } else {
                sb.append(content.toString());
            }
            bufferedFileWriter.write(sb.toString());
        }
    }

    private void processMultiPart(Multipart multipart, StringBuilder sb) throws MessagingException, IOException {
        boolean isAlternativeMultipart = multipart.getContentType().contains("multipart/alternative");
        if (isAlternativeMultipart) {
            this.processAlternativeMultipart(multipart, sb);
        } else {
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (part.getContent() instanceof Multipart) {
                    this.processMultiPart((Multipart)part.getContent(), sb);
                    continue;
                }
                this.processPart((Part)part, sb);
            }
        }
    }

    private void processAlternativeMultipart(Multipart multipart, StringBuilder sb) throws IOException, MessagingException {
        BodyPart partToUse = null;
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.getContentType().contains("text/plain")) {
                partToUse = part;
                break;
            }
            if (part.getContentType().contains("text/html")) {
                partToUse = part;
                continue;
            }
            if (!part.getContentType().contains("multipart/alternative") || !(part.getContent() instanceof Multipart)) continue;
            this.processAlternativeMultipart((Multipart)part.getContent(), sb);
        }
        if (partToUse != null) {
            this.processPart(partToUse, sb);
        }
    }

    private void processPart(Part part, StringBuilder sb) throws IOException, MessagingException {
        boolean isAttachment = "attachment".equalsIgnoreCase(part.getDisposition());
        if (isAttachment) {
            return;
        }
        if (part.getContentType().contains("text/plain")) {
            sb.append(part.getContent().toString());
        } else if (part.getContentType().contains("text/html")) {
            String mailPartContent = part.getContent().toString();
            File tempHtmlFile = FileManager.TempFileProvider.createTempFile((String)"EMLTransformer_", (String)".html");
            String encoding = this.getMailPartContentEncoding(part);
            try (OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tempHtmlFile), encoding);){
                osWriter.write(mailPartContent);
            }
            HtmlParserContentTransformer.EncodingAwareStringBean extractor = new HtmlParserContentTransformer.EncodingAwareStringBean();
            extractor.setCollapse(false);
            extractor.setLinks(false);
            extractor.setReplaceNonBreakingSpaces(false);
            extractor.setURL(tempHtmlFile, encoding);
            sb.append(extractor.getStrings());
            tempHtmlFile.delete();
        }
    }

    private String getMailPartContentEncoding(Part part) throws MessagingException {
        String encoding = DEFAULT_ENCODING;
        String contentType = part.getContentType();
        int startIndex = contentType.indexOf(CHARSET);
        if (startIndex > 0) {
            encoding = contentType.substring(startIndex + CHARSET.length() + 1).replaceAll("\"", "");
        }
        return encoding;
    }
}

