/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.clients.FileInfo;
import org.alfresco.transform.base.clients.HttpClient;
import org.alfresco.transform.base.clients.SourceTarget;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class MiscTransformsIT {
    private static final String ENGINE_URL = "http://localhost:8090";
    private static final Map<String, FileInfo> TEST_FILES = Stream.of(FileInfo.testFile((String)"image/gif", (String)"gif", (String)"sample.gif"), FileInfo.testFile((String)"image/jpeg", (String)"jpg", (String)"sample.jpg"), FileInfo.testFile((String)"image/png", (String)"png", (String)"sample.png"), FileInfo.testFile((String)"image/tiff", (String)"tiff", (String)"sample.tiff"), FileInfo.testFile((String)"application/msword", (String)"doc", (String)"quick.doc"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)"docx", (String)"quick.docx"), FileInfo.testFile((String)"application/vnd.ms-excel", (String)"xls", (String)"quick.xls"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (String)"xlsx", (String)"quick.xlsx"), FileInfo.testFile((String)"application/vnd.ms-powerpoint", (String)"ppt", (String)"quick.ppt"), FileInfo.testFile((String)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (String)"pptx", (String)"quick.pptx"), FileInfo.testFile((String)"application/vnd.ms-outlook", (String)"msg", (String)"quick.msg"), FileInfo.testFile((String)"application/pdf", (String)"pdf", (String)"quick.pdf"), FileInfo.testFile((String)"text/plain", (String)"txt", (String)"quick2.txt"), FileInfo.testFile((String)"text/richtext", (String)"rtf", (String)"sample.rtf"), FileInfo.testFile((String)"text/sgml", (String)"sgml", (String)"sample.sgml"), FileInfo.testFile((String)"text/tab-separated-values", (String)"tsv", (String)"sample.tsv"), FileInfo.testFile((String)"text/x-setext", (String)"etx", (String)"sample.etx"), FileInfo.testFile((String)"text/x-java-source", (String)"java", (String)"Sample.java.txt"), FileInfo.testFile((String)"text/x-jsp", (String)"jsp", (String)"sample.jsp.txt"), FileInfo.testFile((String)"text/x-markdown", (String)"md", (String)"sample.md"), FileInfo.testFile((String)"text/calendar", (String)"ics", (String)"sample.ics"), FileInfo.testFile((String)"text/mediawiki", (String)"mw", (String)"sample.mw"), FileInfo.testFile((String)"text/css", (String)"css", (String)"style.css"), FileInfo.testFile((String)"text/csv", (String)"csv", (String)"people.csv"), FileInfo.testFile((String)"text/javascript", (String)"js", (String)"script.js"), FileInfo.testFile((String)"text/xml", (String)"xml", (String)"quick.xml"), FileInfo.testFile((String)"text/html", (String)"html", (String)"quick.html"), FileInfo.testFile((String)"application/x-javascript", (String)"js", (String)"script.js"), FileInfo.testFile((String)"application/dita+xml", (String)"dita", (String)"quickConcept.dita"), FileInfo.testFile((String)"application/vnd.apple.keynote", (String)"key", (String)"quick.key"), FileInfo.testFile((String)"application/vnd.apple.numbers", (String)"number", (String)"quick.numbers"), FileInfo.testFile((String)"application/vnd.apple.pages", (String)"pages", (String)"quick.pages"), FileInfo.testFile((String)"message/rfc822", (String)"eml", (String)"quick.eml")).collect(Collectors.toMap(FileInfo::getMimeType, Function.identity()));

    public static Stream<SourceTarget> engineTransformations() {
        return Stream.of(SourceTarget.of((String)"text/html", (String)"text/plain"), SourceTarget.of((String)"text/plain", (String)"text/plain"), SourceTarget.of((String)"text/mediawiki", (String)"text/plain"), SourceTarget.of((String)"text/css", (String)"text/plain"), SourceTarget.of((String)"text/csv", (String)"text/plain"), SourceTarget.of((String)"text/xml", (String)"text/plain"), SourceTarget.of((String)"text/html", (String)"text/plain"), SourceTarget.of((String)"text/richtext", (String)"text/plain"), SourceTarget.of((String)"text/sgml", (String)"text/plain"), SourceTarget.of((String)"text/tab-separated-values", (String)"text/plain"), SourceTarget.of((String)"text/x-setext", (String)"text/plain"), SourceTarget.of((String)"text/x-java-source", (String)"text/plain"), SourceTarget.of((String)"text/x-jsp", (String)"text/plain"), SourceTarget.of((String)"text/x-markdown", (String)"text/plain"), SourceTarget.of((String)"text/calendar", (String)"text/plain"), SourceTarget.of((String)"application/x-javascript", (String)"text/plain"), SourceTarget.of((String)"application/dita+xml", (String)"text/plain"), SourceTarget.of((String)"application/vnd.apple.keynote", (String)"image/jpeg"), SourceTarget.of((String)"application/vnd.apple.numbers", (String)"image/jpeg"), SourceTarget.of((String)"application/vnd.apple.pages", (String)"image/jpeg"), SourceTarget.of((String)"text/plain", (String)"application/pdf"), SourceTarget.of((String)"text/csv", (String)"application/pdf"), SourceTarget.of((String)"application/dita+xml", (String)"application/pdf"), SourceTarget.of((String)"text/xml", (String)"application/pdf"), SourceTarget.of((String)"image/tiff", (String)"application/pdf"), SourceTarget.of((String)"message/rfc822", (String)"text/plain"));
    }

    @ParameterizedTest
    @MethodSource(value={"engineTransformations"})
    public void testTransformation(SourceTarget sourceTarget) {
        String sourceMimetype = sourceTarget.source;
        String targetMimetype = sourceTarget.target;
        String sourceFile = TEST_FILES.get(sourceMimetype).getPath();
        String targetExtension = TEST_FILES.get(targetMimetype).getExtension();
        String descriptor = MessageFormat.format("Transform ({0}, {1} -> {2}, {3})", sourceFile, sourceMimetype, targetMimetype, targetExtension);
        try {
            ResponseEntity response = HttpClient.sendTRequest((String)ENGINE_URL, (String)sourceFile, (String)sourceMimetype, (String)targetMimetype, (String)targetExtension);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)descriptor);
            if ("application/pdf".equals(targetMimetype)) {
                PDDocument pdfFile = PDDocument.load((InputStream)Objects.requireNonNull((Resource)response.getBody()).getInputStream());
                Assertions.assertNotNull((Object)pdfFile);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)(descriptor + " exception: " + e.getMessage()));
        }
    }
}

