/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.common;

import java.util.Map;

public class ExtensionService {
    private static final String MIMETYPE_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    private static final String MIMETYPE_CALC_TEMPLATE = "application/vnd.sun.xml.calc.template";
    private static final String MIMETYPE_IMPRESS_TEMPLATE = "application/vnd.sun.xml.impress.template";
    private static final String MIMETYPE_WRITER_TEMPLATE = "application/vnd.sun.xml.writer.template";
    private static final Map<String, String> mimetpeExtensions = Map.ofEntries(Map.entry("application/msword", "doc"), Map.entry("application/vnd.ms-word.document.macroenabled.12", "docm"), Map.entry("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx"), Map.entry("application/vnd.ms-word.template.macroenabled.12", "dotm"), Map.entry("application/vnd.openxmlformats-officedocument.wordprocessingml.template", "dotx"), Map.entry("application/vnd.oasis.opendocument.graphics", "odg"), Map.entry("application/vnd.oasis.opendocument.presentation", "odp"), Map.entry("application/vnd.oasis.opendocument.presentation-template", "otp"), Map.entry("application/vnd.oasis.opendocument.spreadsheet", "ods"), Map.entry("application/vnd.oasis.opendocument.spreadsheet-template", "ots"), Map.entry("application/vnd.oasis.opendocument.text", "odt"), Map.entry("application/vnd.oasis.opendocument.text-template", "ott"), Map.entry("application/vnd.ms-powerpoint.template.macroenabled.12", "potm"), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.template", "potx"), Map.entry("application/vnd.ms-powerpoint.addin.macroenabled.12", "ppam"), Map.entry("application/vnd.ms-powerpoint", "ppt"), Map.entry("application/vnd.ms-powerpoint.presentation.macroenabled.12", "pptm"), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"), Map.entry("application/vnd.ms-powerpoint.slide.macroenabled.12", "sldm"), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.slide", "sldx"), Map.entry("application/vnd.sun.xml.calc.template", "stc"), Map.entry("application/vnd.sun.xml.impress.template", "sti"), Map.entry("application/vnd.sun.xml.writer.template", "stw"), Map.entry("text/tab-separated-values", "tsv"), Map.entry("application/vnd.sun.xml.calc", "sxc"), Map.entry("application/vnd.sun.xml.impress", "sxi"), Map.entry("application/vnd.sun.xml.writer", "sxw"), Map.entry("application/vnd.visio", "vsd"), Map.entry("application/vnd.visio2013", "vsdx"), Map.entry("application/wordperfect", "wp"), Map.entry("application/vnd.ms-excel", "xls"), Map.entry("application/vnd.ms-excel.sheet.binary.macroenabled.12", "xlsb"), Map.entry("application/vnd.ms-excel.sheet.macroenabled.12", "xlsm"), Map.entry("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"), Map.entry("application/vnd.ms-excel.template.macroenabled.12", "xltm"), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.slideshow", "ppsx"), Map.entry("application/vnd.ms-outlook", "msg"), Map.entry("application/dita+xml", "dita"), Map.entry("application/vnd.openxmlformats-officedocument.spreadsheetml.template", "xltx"), Map.entry("image/svg+xml", "svg"), Map.entry("text/plain", "txt"), Map.entry("application/xhtml+xml", "xhtml"), Map.entry("image/x-xwindowdump", "xwd"));

    protected ExtensionService() {
    }

    public static String getExtensionForTargetMimetype(String targetMimetype, String sourceMimetype) {
        if (targetMimetype == null) {
            return null;
        }
        return ExtensionService.getExtensionForMimetype("alfresco-metadata-embed".equals(targetMimetype) ? sourceMimetype : targetMimetype);
    }

    public static String getExtensionForMimetype(String mimetype) {
        if (mimetype == null) {
            return null;
        }
        if (mimetpeExtensions.containsKey(mimetype)) {
            return mimetpeExtensions.get(mimetype);
        }
        if ("alfresco-metadata-extract".equals(mimetype)) {
            return "json";
        }
        return ExtensionService.splitMimetype(mimetype);
    }

    private static String splitMimetype(String mimetype) {
        String[] parts = mimetype.split("[.\\-_|/]");
        return parts[parts.length - 1];
    }
}

