/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformCache;
import org.alfresco.transform.registry.TransformRegistryHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformRegistryHelperTest {
    @Test
    public void testListBySize() {
        SupportedTransform libreoffice = new SupportedTransform("libreoffice", Collections.emptySet(), -1L, 50);
        SupportedTransform textToPdf = new SupportedTransform("textToPdf", Collections.emptySet(), 100L, 55);
        this.assertOrder(Arrays.asList(libreoffice, textToPdf), Arrays.asList(libreoffice));
        this.assertOrder(Arrays.asList(textToPdf, libreoffice), Arrays.asList(libreoffice));
        SupportedTransform p45 = new SupportedTransform("p45", Collections.emptySet(), -1L, 45);
        SupportedTransform p50 = new SupportedTransform("p50", Collections.emptySet(), -1L, 50);
        SupportedTransform p55 = new SupportedTransform("p55", Collections.emptySet(), -1L, 55);
        SupportedTransform s100p45 = new SupportedTransform("s100p45", Collections.emptySet(), 100L, 45);
        SupportedTransform s100p50 = new SupportedTransform("s100p50", Collections.emptySet(), 100L, 50);
        SupportedTransform s100p55 = new SupportedTransform("s100p55", Collections.emptySet(), 100L, 55);
        SupportedTransform s200p50 = new SupportedTransform("s200p50", Collections.emptySet(), 200L, 50);
        SupportedTransform s200p50b = new SupportedTransform("s200p50b", Collections.emptySet(), 200L, 50);
        SupportedTransform s200p55 = new SupportedTransform("s200p55", Collections.emptySet(), 200L, 55);
        SupportedTransform s300p45 = new SupportedTransform("s300p45", Collections.emptySet(), 300L, 45);
        SupportedTransform s300p50 = new SupportedTransform("s300p50", Collections.emptySet(), 300L, 50);
        SupportedTransform s300p55 = new SupportedTransform("s300p55", Collections.emptySet(), 300L, 55);
        this.assertOrder(Arrays.asList(p50), Arrays.asList(p50));
        this.assertOrder(Arrays.asList(p45, p50), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(p50, p55), Arrays.asList(p50));
        this.assertOrder(Arrays.asList(p50, p45), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(p45, p50, p55), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(p50, p55, p45), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(p50, p45, p55), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(s100p45, s100p50, s100p55), Arrays.asList(s100p45));
        this.assertOrder(Arrays.asList(s100p50, s100p45, s100p55), Arrays.asList(s100p45));
        this.assertOrder(Arrays.asList(s100p50), Arrays.asList(s100p50));
        this.assertOrder(Arrays.asList(s100p50, s200p50), Arrays.asList(s200p50));
        this.assertOrder(Arrays.asList(s200p50, s100p50), Arrays.asList(s200p50));
        this.assertOrder(Arrays.asList(s100p50, s200p50, s300p50), Arrays.asList(s300p50));
        this.assertOrder(Arrays.asList(s200p50, s100p50, s300p50), Arrays.asList(s300p50));
        this.assertOrder(Arrays.asList(s300p50, s200p50, s100p50), Arrays.asList(s300p50));
        this.assertOrder(Arrays.asList(s200p50, s200p50b), Arrays.asList(s200p50b));
        this.assertOrder(Arrays.asList(s200p50b, s200p50), Arrays.asList(s200p50));
        this.assertOrder(Arrays.asList(s100p45, s100p50, s200p50, s200p55, s300p45, s300p50, s300p55), Arrays.asList(s300p45));
        this.assertOrder(Arrays.asList(s200p50, s300p55, s300p45, s100p45, s100p50, s300p50, s200p55), Arrays.asList(s300p45));
        this.assertOrder(Arrays.asList(s100p45, s200p50, s300p55), Arrays.asList(s100p45, s200p50, s300p55));
        this.assertOrder(Arrays.asList(s200p50, s100p45, s300p55), Arrays.asList(s100p45, s200p50, s300p55));
        this.assertOrder(Arrays.asList(p45, s100p50, s200p50, s300p55), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(s100p50, s200p50, s300p55, p45), Arrays.asList(p45));
        this.assertOrder(Arrays.asList(p55, s100p50, s200p50, s300p55), Arrays.asList(s200p50, p55));
        this.assertOrder(Arrays.asList(p50, s100p50, s200p50, s300p55), Arrays.asList(p50));
        this.assertOrder(Arrays.asList(s100p50, s200p50, s300p55, p50), Arrays.asList(p50));
    }

    private void assertOrder(List<SupportedTransform> transformsInLoadOrder, List<SupportedTransform> expectedList) {
        AtomicInteger transformerCount = new AtomicInteger(0);
        TransformCache data = new TransformCache();
        transformsInLoadOrder.forEach(t -> data.appendTransform("text/plain", "application/pdf", t, "transformer" + transformerCount.getAndIncrement(), null));
        List supportedTransforms = TransformRegistryHelper.retrieveTransformListBySize((TransformCache)data, (String)"text/plain", (String)"application/pdf", null, null);
        String transformerName = this.findTransformerName(supportedTransforms, 1L);
        long maxSize = this.findMaxSize(supportedTransforms);
        String expectedTransformerName = expectedList.get(0).getName();
        long expectedMaxSourceSizeBytes = this.findMaxSize(expectedList);
        Assertions.assertEquals(expectedList, (Object)supportedTransforms);
        Assertions.assertEquals((Object)expectedTransformerName, (Object)transformerName);
        Assertions.assertEquals((long)expectedMaxSourceSizeBytes, (long)maxSize);
        Assertions.assertEquals(expectedList, (Object)supportedTransforms);
    }

    private String findTransformerName(List<SupportedTransform> supportedTransforms, long sourceSizeInBytes) {
        return supportedTransforms.stream().filter(t -> t.getMaxSourceSizeBytes() == -1L || t.getMaxSourceSizeBytes() >= sourceSizeInBytes).findFirst().map(SupportedTransform::getName).orElse(null);
    }

    private long findMaxSize(List<SupportedTransform> supportedTransforms) {
        return supportedTransforms.isEmpty() ? 0L : supportedTransforms.get(supportedTransforms.size() - 1).getMaxSourceSizeBytes();
    }

    @Test
    public void buildTransformListSourceMimeTypeNullErrorTest() {
        TransformCache data = new TransformCache();
        Assertions.assertThrows(TransformException.class, () -> TransformRegistryHelper.retrieveTransformListBySize((TransformCache)data, null, (String)"application/pdf", null, null));
    }

    @Test
    public void buildTransformListTargetMimeTypeNullErrorTest() {
        TransformCache data = new TransformCache();
        Assertions.assertThrows(TransformException.class, () -> TransformRegistryHelper.retrieveTransformListBySize((TransformCache)data, (String)"text/plain", null, null, null));
    }

    @Test
    public void filterTimeoutTest() {
        TransformCache data = new TransformCache();
        Assertions.assertThrows(TransformException.class, () -> TransformRegistryHelper.retrieveTransformListBySize((TransformCache)data, (String)"text/plain", null, new HashMap(ImmutableMap.of((Object)"timeout", (Object)"1234")), null));
    }

    @Test
    public void filterSourceEncodingTest() {
        TransformCache data = new TransformCache();
        Assertions.assertThrows(TransformException.class, () -> TransformRegistryHelper.retrieveTransformListBySize((TransformCache)data, (String)"text/plain", null, new HashMap(ImmutableMap.of((Object)"sourceEncoding", (Object)"UTF-8")), null));
    }
}

