/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.tika.parsers.ExifToolParser;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.external.ExternalParsersFactory;
import org.apache.tika.parser.image.ImageParser;
import org.apache.tika.parser.image.JpegParser;
import org.apache.tika.parser.image.TiffParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExifToolParser
extends ExternalParser {
    private static final Logger logger = LoggerFactory.getLogger(ExifToolParser.class);
    private static final String EXIFTOOL_PARSER_CONFIG = "parsers/external/config/exiftool-parser.xml";
    protected static final String DEFAULT_SEPARATOR = ", ";
    protected static final String SEPARATOR_SETTING = "-sep";
    private String separator;

    public ExifToolParser() {
        this(null);
    }

    public ExifToolParser(RuntimeExec exifRuntimeExec) {
        try {
            List eParsers = ExternalParsersFactory.create((URL[])new URL[]{this.getExternalParserConfigURL()});
            if (eParsers.size() > 0) {
                CharSequence[] commandToBeExecuted;
                ExternalParser eParser = (ExternalParser)eParsers.get(0);
                if (exifRuntimeExec == null) {
                    logger.debug("Command to be executed determined from Tika ExternalParser");
                    commandToBeExecuted = eParser.getCommand();
                } else {
                    logger.debug("Command to be executed determined from RuntimeExec");
                    commandToBeExecuted = exifRuntimeExec.getCommand();
                }
                if (commandToBeExecuted == null || commandToBeExecuted.length == 0) {
                    commandToBeExecuted = eParser.getCommand();
                }
                String commandToBeExecutedAsString = String.join((CharSequence)" ", commandToBeExecuted);
                logger.debug("Command to be executed: " + commandToBeExecutedAsString);
                this.setCommand(new String[]{commandToBeExecutedAsString});
                this.setIgnoredLineConsumer(eParser.getIgnoredLineConsumer());
                this.setMetadataExtractionPatterns(eParser.getMetadataExtractionPatterns());
                this.setSupportedTypes(eParser.getSupportedTypes());
            } else {
                logger.error("Error creating ExifToolParser from config, ExifToolExtractions not enabled. Please check ExifTool is installed correctly.");
            }
        }
        catch (IOException | TikaException e) {
            logger.error("Error creating ExifToolParser from config, ExifToolExtractions not enabled: ", e);
        }
    }

    private URL getExternalParserConfigURL() {
        ClassLoader classLoader = ExifToolParser.class.getClassLoader();
        return classLoader.getResource(EXIFTOOL_PARSER_CONFIG);
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setCommand(String ... command) {
        super.setCommand(command);
        if (command.length == 1) {
            this.setSeparator(this.findSeparator(command[0]));
        } else {
            this.setSeparator(DEFAULT_SEPARATOR);
        }
    }

    protected String findSeparator(String command) {
        if (command.contains(SEPARATOR_SETTING)) {
            int start = command.indexOf(SEPARATOR_SETTING) + SEPARATOR_SETTING.length() + 1;
            String separator = DEFAULT_SEPARATOR;
            if (command.charAt(start) == '\"') {
                int end = command.indexOf("\"", start + 1);
                separator = command.substring(start + 1, end);
            } else {
                int end = command.indexOf(" ", start);
                separator = command.substring(start, end);
            }
            return separator;
        }
        return DEFAULT_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        MediaType mediaType = MediaType.parse((String)metadata.get("Content-Type"));
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
            if (this.getSupportedTypes().contains(mediaType)) {
                this.parse(tis, xhtml, metadata, tmp);
            }
            switch (mediaType.getType() + "/" + mediaType.getSubtype()) {
                case "image/jpeg": {
                    this.parseAdditional((Parser)new JpegParser(), tis, handler, metadata, context, mediaType);
                    return;
                }
                case "image/tiff": {
                    this.parseAdditional((Parser)new TiffParser(), tis, handler, metadata, context, mediaType);
                    return;
                }
                default: {
                    this.parseAdditional((Parser)new ImageParser(), tis, handler, metadata, context, mediaType);
                    return;
                }
            }
        }
        finally {
            tmp.dispose();
        }
    }

    private void parseAdditional(Parser parser, TikaInputStream tis, ContentHandler handler, Metadata metadata, ParseContext context, MediaType mediaType) throws IOException, SAXException, TikaException {
        if (parser.getSupportedTypes(context).contains(mediaType)) {
            parser.parse((InputStream)tis, handler, metadata, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(TikaInputStream stream, XHTMLContentHandler xhtml, Metadata metadata, TemporaryResources tmp) throws IOException, SAXException, TikaException {
        String[] cmd;
        boolean inputToStdIn = true;
        boolean outputFromStdOut = true;
        boolean hasPatterns = this.getMetadataExtractionPatterns() != null && !this.getMetadataExtractionPatterns().isEmpty();
        File output = null;
        if (this.getCommand().length == 1) {
            cmd = this.getCommand()[0].split(" ");
        } else {
            cmd = new String[this.getCommand().length];
            System.arraycopy(this.getCommand(), 0, cmd, 0, this.getCommand().length);
        }
        for (int i = 0; i < cmd.length; ++i) {
            if (cmd[i].indexOf("${INPUT}") != -1) {
                cmd[i] = cmd[i].replace("${INPUT}", stream.getFile().getPath());
                inputToStdIn = false;
            }
            if (cmd[i].indexOf("${OUTPUT}") == -1) continue;
            output = tmp.createTemporaryFile();
            outputFromStdOut = false;
            cmd[i] = cmd[i].replace("${OUTPUT}", output.getPath());
        }
        Process process = null;
        try {
            process = cmd.length == 1 ? Runtime.getRuntime().exec(cmd[0]) : Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (inputToStdIn) {
                this.sendInput(process, (InputStream)stream);
            } else {
                process.getOutputStream().close();
            }
            InputStream out = process.getInputStream();
            InputStream err = process.getErrorStream();
            if (hasPatterns) {
                if (outputFromStdOut) {
                    this.extractOutput(out, xhtml);
                } else {
                    this.extractMetadata(out, metadata);
                }
            } else {
                this.ignoreStream(err);
                if (outputFromStdOut) {
                    this.extractOutput(out, xhtml);
                } else {
                    this.ignoreStream(out);
                }
            }
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!outputFromStdOut) {
            this.extractOutput((InputStream)new FileInputStream(output), xhtml);
        }
    }

    private void extractOutput(InputStream stream, XHTMLContentHandler xhtml) throws SAXException, IOException {
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
            xhtml.endDocument();
        }
    }

    private void sendInput(Process process, InputStream stream) {
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException ignore) {
            logger.error(ignore.getMessage());
        }
    }

    private void ignoreStream(InputStream stream) {
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void extractMetadata(InputStream stream, Metadata metadata) {
        3 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

