/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.alfresco.transform.tika.metadata.extractors.TikaAutoMetadataExtractor;
import org.alfresco.transform.tika.parsers.ExifToolParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IPTCMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(IPTCMetadataExtractor.class);
    private static Set<String> IPTC_DATE_KEYS = Set.of("XMP-photoshop:DateCreated", "XMP-iptcExt:ArtworkDateCreated");
    private static final Pattern YEAR_IPTC = Pattern.compile("(\\d{4}[:|-]\\d{2}[:|-]\\d{2})");
    private ExifToolParser parser;
    private RuntimeExec exifRuntimeExec;

    public IPTCMetadataExtractor(RuntimeExec exifRuntimeExec) {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
        this.exifRuntimeExec = exifRuntimeExec;
    }

    protected Parser getParser() {
        if (this.parser == null) {
            this.parser = new ExifToolParser(this.exifRuntimeExec);
        }
        return this.parser;
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        properties = new TikaAutoMetadataExtractor().extractSpecific(metadata, properties, headers);
        ExifToolParser etParser = (ExifToolParser)this.getParser();
        if (etParser.getSeparator() != null) {
            for (String key : properties.keySet()) {
                String separator;
                if (!(properties.get(key) instanceof String)) continue;
                String value = (String)properties.get(key);
                if (value.contains(separator = etParser.getSeparator())) {
                    if (value.contains(String.format("\"%s\"", separator))) {
                        separator = String.format("\"%s\"", separator);
                    }
                    String[] values = StringUtils.splitByWholeSeparator((String)value, (String)separator);
                    if (IPTC_DATE_KEYS.contains(key)) {
                        values = this.iptcToIso8601DateStrings(values);
                    }
                    this.putRawValue(key, (Serializable)((Object)Arrays.asList(values)), properties);
                    continue;
                }
                if (!IPTC_DATE_KEYS.contains(key)) continue;
                this.putRawValue(key, (Serializable)((Object)this.iptcToIso8601DateString(value)), properties);
            }
        }
        return properties;
    }

    public String[] iptcToIso8601DateStrings(String[] dateStrings) {
        for (int i = 0; i < dateStrings.length; ++i) {
            dateStrings[i] = this.iptcToIso8601DateString(dateStrings[i]);
        }
        return dateStrings;
    }

    protected String iptcToIso8601DateString(String dateStr) {
        String year;
        char timeSeparator = 'T';
        Matcher yearMatcher = YEAR_IPTC.matcher(dateStr);
        if (yearMatcher.find() && (dateStr = yearMatcher.replaceFirst((year = yearMatcher.group(1)).replaceAll(":", "-"))).length() > year.length() && dateStr.charAt(year.length()) != timeSeparator) {
            dateStr = dateStr.replace(dateStr.charAt(year.length()), timeSeparator);
        }
        return dateStr;
    }
}

