/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MailMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(MailMetadataExtractor.class);
    private static final String KEY_SENT_DATE = "sentDate";
    private static final String KEY_ORIGINATOR = "originator";
    private static final String KEY_ADDRESSEE = "addressee";
    private static final String KEY_ADDRESSEES = "addressees";
    private static final String KEY_SUBJECT = "subjectLine";
    private static final String KEY_TO_NAMES = "toNames";
    private static final String KEY_CC_NAMES = "ccNames";
    private static final String KEY_BCC_NAMES = "bccNames";

    public MailMetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    protected Parser getParser() {
        return new OfficeParser();
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_ORIGINATOR, (Serializable)((Object)metadata.get(TikaCoreProperties.CREATOR)), properties);
        this.putRawValue(KEY_SUBJECT, (Serializable)((Object)metadata.get(TikaCoreProperties.TITLE)), properties);
        this.putRawValue("description", (Serializable)((Object)metadata.get(TikaCoreProperties.SUBJECT)), properties);
        this.putRawValue(KEY_SENT_DATE, (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIED)), properties);
        this.putRawValue(KEY_ADDRESSEE, (Serializable)((Object)metadata.get("Message-To")), properties);
        this.putRawValue(KEY_TO_NAMES, (Serializable)metadata.getValues("Message-To"), properties);
        this.putRawValue(KEY_CC_NAMES, (Serializable)metadata.getValues("Message-Cc"), properties);
        this.putRawValue(KEY_BCC_NAMES, (Serializable)metadata.getValues("Message-Bcc"), properties);
        this.putRawValue(KEY_ADDRESSEES, (Serializable)metadata.getValues("Message-Recipient-Address"), properties);
        return properties;
    }
}

