/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transformer.logging.LogEntry;
import org.alfresco.transformer.probes.ProbeTestTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Deprecated
public interface TransformController {
    public static final Logger logger = LoggerFactory.getLogger(TransformController.class);

    public void transformImpl(String var1, String var2, String var3, Map<String, String> var4, File var5, File var6);

    @Deprecated
    public ResponseEntity<TransformReply> transform(TransformRequest var1, Long var2);

    @Deprecated
    default public void processTransform(File sourceFile, File targetFile, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, Long timeout) {
    }

    public String getTransformerName();

    public ProbeTestTransform getProbeTestTransform();

    default public String probe(HttpServletRequest request, boolean isLiveProbe) {
        return this.getProbeTestTransform().doTransformOrNothing(request, isLiveProbe);
    }

    @RequestMapping(value={"/version"})
    @ResponseBody
    public String version();

    @GetMapping(value={"/"})
    default public String transformForm(Model model) {
        return "transformForm";
    }

    @GetMapping(value={"/error"})
    default public String error() {
        return "error";
    }

    @GetMapping(value={"/log"})
    default public String log(Model model) {
        model.addAttribute("title", (Object)(this.getTransformerName() + " Log Entries"));
        Collection<LogEntry> log = LogEntry.getLog();
        if (!log.isEmpty()) {
            model.addAttribute("log", log);
        }
        return "log";
    }

    @GetMapping(value={"/ready"})
    @ResponseBody
    default public String ready(HttpServletRequest request) {
        return this.probe(request, false);
    }

    @GetMapping(value={"/live"})
    @ResponseBody
    default public String live(HttpServletRequest request) {
        return this.probe(request, true);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    default public void handleParamsTypeMismatch(HttpServletResponse response, MissingServletRequestParameterException e) throws IOException {
        String message = MessageFormat.format("Request parameter ''{0}'' is of the wrong type", e.getParameterName());
        int statusCode = HttpStatus.BAD_REQUEST.value();
        logger.error(message, (Throwable)e);
        LogEntry.setStatusCodeAndMessage(statusCode, message);
        response.sendError(statusCode, this.getTransformerName() + " - " + message);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    default public void handleMissingParams(HttpServletResponse response, MissingServletRequestParameterException e) throws IOException {
        String message = MessageFormat.format("Request parameter ''{0}'' is missing", e.getParameterName());
        int statusCode = HttpStatus.BAD_REQUEST.value();
        logger.error(message, (Throwable)e);
        LogEntry.setStatusCodeAndMessage(statusCode, message);
        response.sendError(statusCode, this.getTransformerName() + " - " + message);
    }

    @ExceptionHandler(value={TransformException.class})
    default public void transformExceptionWithMessage(HttpServletResponse response, TransformException e) throws IOException {
        String message = e.getMessage();
        int statusCode = e.getStatus().value();
        logger.error(message, (Throwable)e);
        long time = LogEntry.setStatusCodeAndMessage(statusCode, message);
        this.getProbeTestTransform().recordTransformTime(time);
        response.sendError(statusCode, this.getTransformerName() + " - " + message);
    }
}

