/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.impl.StreamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingContentStreamImpl
implements ContentStream {
    private static final Log log = LogFactory.getLog(CachingContentStreamImpl.class);
    private static final String SYSTEM_PROPERTY_TEMP_DIR = "java.io.tmpdir";
    private static String WQS_TEMP_FOLDER_NAME = "alfresco-wqs";
    private final String fileName;
    private final String mimeType;
    private final long length;
    private final transient File cacheFile;

    public CachingContentStreamImpl(ContentStream contentStream) throws IOException {
        this.fileName = contentStream.getFileName();
        this.length = contentStream.getLength();
        this.mimeType = contentStream.getMimeType();
        File tempFile = File.createTempFile("wqscontent-", null, this.getTempDir());
        tempFile.deleteOnExit();
        log.debug((Object)("Created temp cache file: " + tempFile.getPath()));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile));
        contentStream.output(os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        this.cacheFile = tempFile;
    }

    public static void setTempFolderName(String folderName) {
        WQS_TEMP_FOLDER_NAME = folderName;
    }

    private File getSystemTempDir() throws IOException {
        String systemTempDirPath = System.getProperty(SYSTEM_PROPERTY_TEMP_DIR);
        if (systemTempDirPath == null) {
            throw new IOException("System property not available: java.io.tmpdir");
        }
        return new File(systemTempDirPath);
    }

    private File getTempDir() throws IOException {
        File systemTempDir = this.getSystemTempDir();
        File tempDir = new File(systemTempDir, WQS_TEMP_FOLDER_NAME);
        if (!tempDir.exists()) {
            if (!tempDir.mkdirs()) {
                throw new IOException("Failed to create temp directory: " + tempDir);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created temp directory: " + tempDir));
            }
        }
        return tempDir;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getStream() {
        try {
            return new FileInputStream(this.cacheFile);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"Failed to open input stream for cached content file", (Throwable)e);
            return null;
        }
    }

    @Override
    public void output(OutputStream output) throws IOException {
        try (FileInputStream is = new FileInputStream(this.cacheFile);){
            StreamUtils.output(is, output);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        try (FileInputStream is = new FileInputStream(this.cacheFile);){
            StreamUtils.write(is, writer, "UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, String encoding) throws IOException {
        try (FileInputStream is = new FileInputStream(this.cacheFile);){
            StreamUtils.write(is, writer, encoding);
        }
    }

    public void finalize() {
        if (this.cacheFile != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to delete temp cache file " + this.cacheFile.getPath()));
            }
            this.cacheFile.delete();
        }
    }
}

