/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.DictionaryService;
import org.alfresco.wcm.client.PathResolutionDetails;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.Tag;
import org.alfresco.wcm.client.impl.PathImpl;
import org.alfresco.wcm.client.impl.PathResolutionDetailsImpl;
import org.alfresco.wcm.client.impl.ResourceBaseImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionImpl
extends ResourceBaseImpl
implements Section {
    private static final long serialVersionUID = -443446798048387948L;
    private static final Log log = LogFactory.getLog(SectionImpl.class);
    private List<Section> sections = new ArrayList<Section>();
    private Map<String, Section> sectionsByName = new TreeMap<String, Section>();
    private ConcurrentMap<String, String> assetIdByAssetName = new ConcurrentHashMap<String, String>(89);
    private List<Tag> tags = new ArrayList<Tag>();
    private Map<String, String> configMap;
    private DictionaryService dictionaryService;
    private Map<String, String> redirects;

    @Override
    public List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    @Override
    public Section getSection(String sectionName) {
        return this.sectionsByName.get(sectionName);
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public Map<String, String> getTemplateMappings() {
        return Collections.unmodifiableMap(this.configMap);
    }

    @Override
    public boolean getExcludeFromNav() {
        Boolean exclude = (Boolean)this.getProperty("ws:excludeFromNavigation");
        return exclude == null ? false : exclude;
    }

    void setSections(List<Section> sections) {
        this.sections = sections;
        TreeMap<String, Section> newMap = new TreeMap<String, Section>();
        for (Section section : sections) {
            newMap.put(section.getName(), section);
        }
        this.sectionsByName = newMap;
    }

    @Override
    public void setProperties(Map<String, Serializable> props) {
        super.setProperties(props);
        this.configMap = this.parseConfigProperties((List)((Object)props.get("ws:sectionConfig")));
        this.redirects = this.parseConfigProperties((List)((Object)props.get("ws:redirectConfig")));
    }

    private Map<String, String> parseConfigProperties(List<String> configPropertyList) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (configPropertyList != null) {
            for (String configValue : configPropertyList) {
                String[] split = configValue.split("=");
                if (split.length != 2) continue;
                String name = split[0];
                String value = split[1];
                result.put(name, value);
                if ("cmis:document".equals(name)) {
                    result.put("cm:content", value);
                    continue;
                }
                if (!"cm:content".equals(name)) continue;
                result.put("cmis:document", value);
            }
        }
        return result;
    }

    void addChild(Section section) {
        this.sections.add(section);
        this.sectionsByName.put(section.getName(), section);
    }

    @Override
    public Asset getAsset(String resourceName) {
        Asset asset;
        if (resourceName == null || resourceName.length() == 0) {
            asset = this.getIndexPage();
        } else {
            String assetId = (String)this.assetIdByAssetName.get(resourceName);
            if (assetId == null) {
                asset = this.getAssetFactory().getSectionAsset(this.getId(), resourceName);
                if (asset != null) {
                    this.assetIdByAssetName.putIfAbsent(resourceName, asset.getId());
                }
            } else {
                asset = this.getAssetFactory().getAssetById(assetId);
            }
        }
        return asset;
    }

    @Override
    public Asset getIndexPage() {
        return this.getAsset("index.html");
    }

    @Override
    public String getPath() {
        StringBuilder sb = new StringBuilder("/");
        Section section = this;
        while (section.getContainingSection() != null) {
            sb.insert(0, "/" + section.getName());
            section = section.getContainingSection();
        }
        return sb.toString();
    }

    @Override
    public SearchResults search(Query query) {
        return this.getAssetFactory().findByQuery(query);
    }

    @Override
    public SearchResults search(String phrase, int maxResults, int resultsToSkip) {
        Query query = this.createQuery();
        query.setPhrase(phrase);
        query.setMaxResults(maxResults);
        query.setResultsToSkip(resultsToSkip);
        return this.search(query);
    }

    @Override
    public SearchResults searchByTag(String tag, int maxResults, int resultsToSkip) {
        Query query = this.createQuery();
        query.setTag(tag);
        query.setMaxResults(maxResults);
        query.setResultsToSkip(resultsToSkip);
        return this.search(query);
    }

    @Override
    public Query createQuery() {
        Query query = new Query();
        query.setSectionId(this.getId());
        return query;
    }

    @Override
    public String getTemplate(String type) {
        type = this.dictionaryService.removeTypePrefix(type);
        return this.findTemplate(this, type);
    }

    @Override
    public AssetCollection getAssetCollection(String name) {
        return this.getCollectionFactory().getCollection(this.getId(), name);
    }

    @Override
    public AssetCollection getAssetCollection(String name, int resultsToSkip, int maxResults) {
        return this.getCollectionFactory().getCollection(this.getId(), name, resultsToSkip, maxResults);
    }

    private String findTemplate(Section section, String type) {
        String template = null;
        template = this.findTemplate(section.getTemplateMappings(), type);
        Section parent = section.getContainingSection();
        if (template == null && parent != null) {
            template = this.findTemplate(parent, type);
        }
        return template;
    }

    private String findTemplate(Map<String, String> templateMap, String type) {
        String parentType;
        String template = templateMap.get(type);
        if (template == null && !this.dictionaryService.isRootType(type) && (parentType = this.dictionaryService.getParentType(type, true)) != null) {
            template = this.findTemplate(templateMap, parentType);
        }
        return template;
    }

    @Override
    public PathResolutionDetails resolvePath(String path) {
        PathResolutionDetailsImpl details = new PathResolutionDetailsImpl();
        String redirectLocation = this.checkRedirects(path);
        if (redirectLocation == null) {
            Asset asset = null;
            PathImpl segmentedPath = new PathImpl(path);
            String[] sectionPath = segmentedPath.getPathSegments();
            String resourceName = segmentedPath.getResourceName();
            Section section = this.getSectionFactory().getSectionFromPathSegments(this.getId(), sectionPath);
            if (section != null) {
                if (resourceName != null && resourceName.length() > 0) {
                    try {
                        String decodedResourceName = URLDecoder.decode(resourceName, "UTF-8");
                        asset = section.getAsset(decodedResourceName);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (asset == null) {
                        asset = section.getAsset(resourceName);
                    }
                } else {
                    asset = section.getIndexPage();
                }
            }
            details.setAsset(asset);
            details.setSection(section);
        } else {
            details.setRedirect(true);
            details.setRedirectLocation(redirectLocation);
        }
        return details;
    }

    protected String checkRedirects(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking for redirect on path " + path + "  Defined redirects are " + this.redirects));
        }
        return this.redirects.get(path);
    }
}

