/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl.cache;

import java.io.Serializable;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.alfresco.wcm.client.impl.cache.CacheException;
import org.alfresco.wcm.client.impl.cache.SimpleCache;

public class EhCacheAdapter<K extends Serializable, V>
implements SimpleCache<K, V> {
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K key) {
        try {
            return this.cache.get(key) != null;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException("contains failed", e);
        }
    }

    @Override
    public Collection<K> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public V get(K key) {
        try {
            Element element = this.cache.get(key);
            if (element != null) {
                return (V)element.getObjectValue();
            }
            return null;
        }
        catch (IllegalStateException ie) {
            throw new CacheException("Failed to get from EhCache as state invalid: \n  state: " + this.cache.getStatus() + "\n   key: " + key, ie);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException("Failed to get from EhCache: \n   key: " + key, e);
        }
    }

    @Override
    public void put(K key, V value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }
}

