/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;

public class AlfrescoTicketCmisAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final long serialVersionUID = -4750134562719908905L;
    private String ticket = null;
    private WebScriptCaller webscriptCaller;
    private ReentrantLock ticketLock = new ReentrantLock(true);
    private long ticketLastFetched = System.currentTimeMillis();
    private long refetchTicketNotBefore = System.currentTimeMillis();
    private long refetchTicketDelay = 10000L;
    private long ticketDuration = 3600000L;

    public void setWebscriptCaller(WebScriptCaller webscriptCaller) {
        this.webscriptCaller = webscriptCaller;
    }

    public void setTicketDuration(long ticketDuration) {
        this.ticketDuration = ticketDuration;
    }

    protected void setRefetchTicketDelay(long refetchTicketDelay) {
        this.refetchTicketDelay = refetchTicketDelay;
    }

    protected String getPassword() {
        return this.getTicket();
    }

    protected String getUser() {
        return "";
    }

    private String getTicket() {
        boolean refetchTicket;
        boolean bl = refetchTicket = System.currentTimeMillis() >= this.ticketLastFetched + this.ticketDuration;
        if (this.ticket == null || refetchTicket) {
            this.ticketLock.lock();
            try {
                if (this.ticket == null || refetchTicket) {
                    this.ticket = this.webscriptCaller.getTicket(super.getUser(), super.getPassword());
                    this.ticketLastFetched = System.currentTimeMillis();
                    this.refetchTicketNotBefore = System.currentTimeMillis() + this.refetchTicketDelay;
                }
            }
            finally {
                this.ticketLock.unlock();
            }
        }
        return this.ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResponseHeaders(String url, int statusCode, Map<String, List<String>> headers) {
        super.putResponseHeaders(url, statusCode, headers);
        if (statusCode == 401 || statusCode == 403) {
            this.ticketLock.lock();
            try {
                if (System.currentTimeMillis() >= this.refetchTicketNotBefore) {
                    this.ticket = null;
                }
            }
            finally {
                this.ticketLock.unlock();
            }
        }
    }
}

