/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client;

import junit.framework.TestCase;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.DictionaryService;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.CmisSessionPool;
import org.apache.chemistry.opencmis.client.api.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class BaseTest
extends TestCase {
    protected static final String HOST = "localhost";
    protected static final int PORT = 8080;
    protected ApplicationContext appContext;
    protected CmisSessionPool sessionPool;
    protected Session session = null;
    protected SectionFactory sectionFactory;
    protected AssetFactory assetFactory;
    protected CollectionFactory collectionFactory;
    protected WebSiteService webSiteService;
    protected DictionaryService dictionaryService;

    protected void setUp() throws Exception {
        super.setUp();
        this.appContext = new ClassPathXmlApplicationContext("alfresco/wcmqs-api-context.xml");
        this.sessionPool = (CmisSessionPool)this.appContext.getBean("sessionPool");
        for (int i = 0; i < 5; ++i) {
            try {
                this.session = this.sessionPool.getGuestSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.session != null) break;
            Thread.sleep(1000L);
        }
        CmisSessionHelper.setSession((Session)this.session);
        this.sectionFactory = (SectionFactory)this.appContext.getBean("sectionFactory");
        this.assetFactory = (AssetFactory)this.appContext.getBean("assetFactory");
        this.collectionFactory = (CollectionFactory)this.appContext.getBean("collectionFactory");
        this.webSiteService = (WebSiteService)this.appContext.getBean("webSiteService");
        this.dictionaryService = (DictionaryService)this.appContext.getBean("dictionaryService");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.sessionPool.closeSession(this.session);
    }

    protected WebSite getWebSite() {
        WebSite site = this.webSiteService.getWebSite(HOST, 8080, "wcmqs");
        BaseTest.assertNotNull((String)"Unable to find site for host localhost and port 8080", (Object)site);
        return site;
    }

    protected Section getRootSection() {
        WebSite site = this.getWebSite();
        Section section = site.getRootSection();
        BaseTest.assertNotNull((String)"Root section should not be null", (Object)section);
        return section;
    }
}

