/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.util.impl.AlfrescoTicketCmisAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AlfrescoTicketCmisAuthenticationProviderTest {
    AlfrescoTicketCmisAuthenticationProvider authProvider;

    @Before
    public void setUp() throws Exception {
        WebScriptCaller mockedWebscriptCaller = (WebScriptCaller)Mockito.mock(WebScriptCaller.class);
        Mockito.when((Object)mockedWebscriptCaller.getTicket((String)Mockito.any(String.class), (String)Mockito.any(String.class))).thenAnswer((Answer)new Answer<String>(this){
            private int ticketNum = 1;

            public String answer(InvocationOnMock invocation) throws Throwable {
                return "ticket" + this.ticketNum++;
            }
        });
        BindingSession mockedSession = (BindingSession)Mockito.mock(BindingSession.class);
        Mockito.when((Object)mockedSession.get("org.apache.chemistry.opencmis.user")).thenReturn((Object)"admin");
        Mockito.when((Object)mockedSession.get("org.apache.chemistry.opencmis.password")).thenReturn((Object)"admin");
        this.authProvider = new AlfrescoTicketCmisAuthenticationProvider();
        this.authProvider.setWebscriptCaller(mockedWebscriptCaller);
        this.authProvider.setSession(mockedSession);
        this.authProvider.setRefetchTicketDelay(2000L);
    }

    @Test
    public void testGetPassword() {
        TreeSet<String> replies = new TreeSet<String>();
        for (int i = 0; i < 1000; ++i) {
            replies.add(this.authProvider.getPassword());
        }
        junit.framework.Assert.assertEquals((int)1, (int)replies.size());
        for (String reply : replies) {
            junit.framework.Assert.assertTrue((boolean)reply.startsWith("ticket"));
        }
    }

    @Test
    public void testGetPasswordWithErrors() throws InterruptedException {
        TreeSet<String> replies = new TreeSet<String>();
        long stopTime = System.currentTimeMillis() + 3000L;
        while (stopTime > System.currentTimeMillis()) {
            replies.add(this.authProvider.getPassword());
            this.authProvider.putResponseHeaders(null, 401, null);
            Thread.sleep(10L);
        }
        junit.framework.Assert.assertEquals((int)2, (int)replies.size());
        for (String reply : replies) {
            junit.framework.Assert.assertTrue((boolean)reply.startsWith("ticket"));
        }
    }

    @Test
    public void testMultithreadedGetPasswordWithErrors() throws InterruptedException {
        int i;
        final Set<String> replies = Collections.synchronizedSet(new TreeSet());
        final long stopTime = System.currentTimeMillis() + 3000L;
        final List<Thread> threads = Collections.synchronizedList(new ArrayList(20));
        for (i = 0; i < 20; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (stopTime > System.currentTimeMillis()) {
                        replies.add(AlfrescoTicketCmisAuthenticationProviderTest.this.authProvider.getPassword());
                        AlfrescoTicketCmisAuthenticationProviderTest.this.authProvider.putResponseHeaders(null, 401, null);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    threads.remove(Thread.currentThread());
                }
            });
            threads.add(thread);
            thread.start();
        }
        i = 0;
        while (!threads.isEmpty()) {
            if (i >= 600) {
                Assert.fail((String)("Not all threads (" + threads.size() + ") are still to finish."));
            }
            Thread.sleep(500L);
            ++i;
        }
        junit.framework.Assert.assertEquals((int)2, (int)replies.size());
        for (String reply : replies) {
            junit.framework.Assert.assertTrue((boolean)reply.startsWith("ticket"));
        }
    }
}

