/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.SearchResult;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.impl.AssetDeserializerXmlImpl;
import org.alfresco.wcm.client.impl.AssetImpl;
import org.alfresco.wcm.client.impl.SearchResultAssetImpl;
import org.alfresco.wcm.client.impl.SearchResultsImpl;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.impl.WebscriptParam;
import org.alfresco.wcm.client.impl.WebscriptResponseHandler;

public class AssetFactoryWebscriptImpl
implements AssetFactory {
    private WebScriptCaller webscriptCaller;
    private SectionFactory sectionFactory;
    private CollectionFactory collectionFactory;
    private AssetFactory supportingAssetFactory;
    private ThreadLocal<List<WebscriptParam>> localParamList = new ThreadLocal<List<WebscriptParam>>(this){

        @Override
        protected List<WebscriptParam> initialValue() {
            return new ArrayList<WebscriptParam>();
        }

        @Override
        public List<WebscriptParam> get() {
            List list = (List)super.get();
            list.clear();
            return list;
        }
    };

    public void setWebscriptCaller(WebScriptCaller webscriptCaller) {
        this.webscriptCaller = webscriptCaller;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public void setSupportingAssetFactory(AssetFactory supportingAssetFactory) {
        this.supportingAssetFactory = supportingAssetFactory;
    }

    @Override
    public SearchResults findByQuery(Query query) {
        SearchResultsImpl results = new SearchResultsImpl();
        results.setQuery(query);
        if (query != null && query.getSectionId() != null) {
            String phrase = query.getPhrase();
            String tag = query.getTag();
            if (phrase != null && phrase.length() > 0 || tag != null && tag.length() > 0) {
                List<WebscriptParam> params = this.localParamList.get();
                params.add(new WebscriptParam("sectionid", query.getSectionId()));
                WebSite currentSite = WebSiteService.getThreadWebSite();
                if (currentSite != null) {
                    params.add(new WebscriptParam("siteid", currentSite.getId()));
                }
                if (query.getTag() != null) {
                    params.add(new WebscriptParam("tag", query.getTag()));
                }
                if (query.getPhrase() != null) {
                    params.add(new WebscriptParam("phrase", query.getPhrase()));
                }
                params.add(new WebscriptParam("skip", Integer.toString(query.getResultsToSkip())));
                params.add(new WebscriptParam("max", Integer.toString(query.getMaxResults())));
                TreeMap<String, Serializable> headerProps = new TreeMap<String, Serializable>();
                LinkedList<TreeMap<String, Serializable>> assets = this.searchAssetsInRepo(params, headerProps);
                Long totalResults = (Long)headerProps.get("totalResults");
                results.setTotalSize(totalResults == null ? (long)assets.size() : totalResults);
                ArrayList<SearchResult> resultList = new ArrayList<SearchResult>(assets.size());
                for (TreeMap treeMap : assets) {
                    resultList.add(this.buildSearchResult(treeMap));
                }
                results.setResults(resultList);
            }
        }
        return results;
    }

    @Override
    public Asset getAssetById(String id) {
        return this.getAssetById(id, false);
    }

    @Override
    public Asset getAssetById(String id, boolean deferredLoad) {
        Asset asset = null;
        LinkedList<TreeMap<String, Serializable>> assetList = this.getAssetsFromRepo(new WebscriptParam("noderef", id));
        if (!assetList.isEmpty()) {
            asset = this.buildAsset(assetList.get(0));
        }
        return asset;
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids) {
        return this.getAssetsById(ids, false);
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids, boolean deferredLoad) {
        ArrayList<Asset> results = new ArrayList<Asset>(ids.size());
        List<WebscriptParam> params = this.localParamList.get();
        for (String id : ids) {
            params.add(new WebscriptParam("noderef", id));
        }
        LinkedList<TreeMap<String, Serializable>> assetDataList = this.getAssetsFromRepo(params);
        for (TreeMap treeMap : assetDataList) {
            results.add(this.buildAsset(treeMap));
        }
        return results;
    }

    @Override
    public Date getModifiedTimeOfAsset(String assetId) {
        Date result = null;
        List<WebscriptParam> paramList = this.localParamList.get();
        paramList.add(new WebscriptParam("noderef", assetId));
        paramList.add(new WebscriptParam("modifiedTimeOnly", "true"));
        LinkedList<TreeMap<String, Serializable>> assetList = this.getAssetsFromRepo(paramList);
        if (!assetList.isEmpty()) {
            TreeMap<String, Serializable> assetData = assetList.get(0);
            result = (Date)assetData.get("cm:modified");
        }
        return result;
    }

    @Override
    public Map<String, Date> getModifiedTimesOfAssets(Collection<String> assetIds) {
        TreeMap<String, Date> result = new TreeMap<String, Date>();
        List<WebscriptParam> params = this.localParamList.get();
        for (String id : assetIds) {
            params.add(new WebscriptParam("noderef", id));
        }
        params.add(new WebscriptParam("modifiedTimeOnly", "true"));
        LinkedList<TreeMap<String, Serializable>> assetList = this.getAssetsFromRepo(params);
        for (TreeMap treeMap : assetList) {
            result.put((String)treeMap.get("id"), (Date)treeMap.get("cm:modified"));
        }
        return result;
    }

    @Override
    public Map<String, Rendition> getRenditions(String assetId) {
        return this.supportingAssetFactory.getRenditions(assetId);
    }

    @Override
    public Asset getSectionAsset(String sectionId, String assetName) {
        return this.getSectionAsset(sectionId, assetName, false);
    }

    @Override
    public Asset getSectionAsset(String sectionId, String assetName, boolean wildcardsAllowedInName) {
        Asset asset = null;
        List<WebscriptParam> paramList = this.localParamList.get();
        WebSite currentSite = WebSiteService.getThreadWebSite();
        if (currentSite != null) {
            paramList.add(new WebscriptParam("siteid", currentSite.getId()));
        }
        paramList.add(new WebscriptParam("sectionid", sectionId));
        paramList.add(new WebscriptParam("nodename", assetName));
        LinkedList<TreeMap<String, Serializable>> assetList = this.getAssetsFromRepo(paramList);
        if (!assetList.isEmpty()) {
            asset = this.buildAsset(assetList.get(0));
        }
        return asset;
    }

    @Override
    public Map<String, List<String>> getSourceRelationships(String assetId) {
        return this.supportingAssetFactory.getSourceRelationships(assetId);
    }

    private LinkedList<TreeMap<String, Serializable>> getAssetsFromRepo(WebscriptParam ... params) {
        return this.getAssetsFromRepo(Arrays.asList(params));
    }

    private LinkedList<TreeMap<String, Serializable>> getAssetsFromRepo(List<WebscriptParam> params) {
        return this.getAssetsFromRepo(params, null);
    }

    private LinkedList<TreeMap<String, Serializable>> getAssetsFromRepo(List<WebscriptParam> params, Map<String, Serializable> header) {
        AssetDeserializerXmlImpl deserializer = new AssetDeserializerXmlImpl();
        this.webscriptCaller.post("webasset", deserializer, params);
        LinkedList<TreeMap<String, Serializable>> assetList = deserializer.getAssets();
        if (header != null) {
            header.putAll(deserializer.getHeader());
        }
        return assetList;
    }

    private LinkedList<TreeMap<String, Serializable>> searchAssetsInRepo(List<WebscriptParam> params, Map<String, Serializable> header) {
        AssetDeserializerXmlImpl deserializer = new AssetDeserializerXmlImpl();
        this.webscriptCaller.get("webassetsearch", (WebscriptResponseHandler)deserializer, params);
        LinkedList<TreeMap<String, Serializable>> assetList = deserializer.getAssets();
        if (header != null && deserializer.getHeader() != null) {
            header.putAll(deserializer.getHeader());
        }
        return assetList;
    }

    protected Asset buildAsset(TreeMap<String, Serializable> props) {
        AssetImpl asset = new AssetImpl();
        asset.setProperties(props);
        asset.setParentSectionIds((Collection)((Object)props.get("ws:parentSections")));
        asset.setSectionFactory(this.sectionFactory);
        asset.setCollectionFactory(this.collectionFactory);
        asset.setAssetFactory(this);
        return asset;
    }

    protected SearchResult buildSearchResult(TreeMap<String, Serializable> props) {
        Asset asset = this.buildAsset(props);
        Long score = (Long)asset.getProperty("searchScore");
        if (score == null) {
            score = 0L;
        }
        SearchResultAssetImpl result = new SearchResultAssetImpl(asset, score.intValue());
        return result;
    }

    @Override
    public ContentStream getContentStream(String assetId) {
        return this.supportingAssetFactory.getContentStream(assetId);
    }
}

