/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.exception.PageNotFoundException;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.mvc.UrlViewController;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class GenericTemplateAssetController
extends UrlViewController {
    private List<Pattern> staticPages;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getPathInfo();
        String context = request.getContextPath();
        if (path.endsWith("/index.html")) {
            int lastDelim = path.lastIndexOf(47);
            String uri = context + path.substring(0, lastDelim + 1);
            RedirectView redirect = new RedirectView(uri, false, false);
            redirect.setStatusCode((HttpStatusCode)HttpStatus.MOVED_PERMANENTLY);
            return new ModelAndView((View)redirect);
        }
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        Asset asset = (Asset)requestContext.getValue("asset");
        if (asset == null && !this.isStatic(path)) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            throw new PageNotFoundException(path);
        }
        return super.handleRequestInternal(request, response);
    }

    private boolean isStatic(String path) {
        for (Pattern staticPage : this.staticPages) {
            Matcher matcher = staticPage.matcher(path);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public void setStaticPages(Set<String> staticPages) {
        this.staticPages = new ArrayList();
        for (String staticPage : staticPages) {
            this.staticPages.add(Pattern.compile(staticPage));
        }
    }
}

